(function () {
    $("#vc_party_id").focus();
}());


/*payment voucher */
	function get_group_data(id)
	{
		if(id > 0)
		{
			var path = base_url+"voucherctrl/get_group_data/"+id;  

			$("#loading").show();
			$.ajax({
				type:'GET',
				url:path,
				dataType:'json',
				success:function(resp)
				{	
					var data = "";
					data += '<select class="form-control" id="vc_party_id" name="vc_party_id" onchange="get_party_balance_status();">';
					data += '<option value="0">PLEASE SELECT</option>'
					// console.log(resp);
					$.each(resp, function(index, value){
						if (id == 5) 
						{
                        	data += '<option value="'+value['client_id']+'">'+value['client_name']+' - '+value['client_mobile1'] +'</option>';
						}
						else if (id == 6) 
						{
                        	data += '<option value="'+value['acc_id']+'">'+value['acc_name']+' - '+value['acc_mobile']+'</option>';
						}
						else
						{
                        	data += '<option value="'+value['km_id']+'">'+value['km_name']+' - '+value['km_mob']+'</option>';
						}
                    });
					data += '</select>';

					$("#party_id").html(data);
					$("#vc_party_id").flexselect();

					$("#vc_payment_status").val("");
					$("#loading").hide();
				},
				error:function(err){
					console.log(err);
				}   
			});
		}
		else
		{
			$("#vc_payment_status").val(0);
		}
	}

	function get_party_balance_status()
	{
		var party_id = parseFloat($("#vc_party_id").val());
		var grp_id 	 = parseFloat($("#vc_grp_id").val());
		var vc_type  = parseFloat($("#vc_voucher_type").val());

		console.log(grp_id);


		if((party_id > 0) && (grp_id > 0))
		{
			var path = base_url+"voucherctrl/get_party_balance_status/"+party_id+"/"+grp_id;  

			$("#loading").show();
			$.ajax({
				type:'GET',
				url:path,
				dataType:'json',
				success:function(resp)
				{
					console.log(resp);
					// console.log(vc_type);
					// console.log(grp_id);
					$("#vc_payment_status").val(resp['status']);
					
					$("#vc_mob_no").val(resp['acc_mob_no']);

					if (vc_type == 1 && grp_id == 7) 
					{
						get_party_bill_details();
					}
					else if (vc_type == 2 && grp_id == 5) 
					{
						get_party_bill_details();
					}
					else if (vc_type == 1 && grp_id == 6) 
					{
						get_party_bill_details();
					}
					
					$("#loading").hide();
				},
				error:function(err){
					console.log(err);
				}   
			});
		}
		else
		{
			$("#vc_payment_status").val(0);
		}
	}


	var voucher_cnt = 1;
	function get_party_bill_details()
	{
		var grp_id 	= parseFloat($("#vc_grp_id").val());
		var party_id 	= parseFloat($("#vc_party_id").val());

		// console.log(grp_id);
		// console.log(party_id);

		var vc_payment_status = $("#vc_payment_status").val();

		if(vc_payment_status != "0 TO RECEIVE")
		{
			vc_payment_bal = "-1";
		}
		else
		{
			vc_payment_bal = vc_payment_status.indexOf("PAY");
		}
	
		if(party_id > 0)
		{
			// console.log("xyz");

			var path = base_url+"voucherctrl/get_party_order_details/"+party_id+"/"+grp_id;  

			$("#loading").show();
			$.ajax({
				type:'POST',
				url:path,
				dataType:'json',
				success:function(resp)
				{
					console.log(resp);
					var data = '';
					var len = resp.length;
					if(isNaN(len)) len = 0;
					if(resp.length != 0)
					{   
						if (grp_id == 5) 
						{
							data += '<table class="table">';

							data += '<tr>';
							data += '<th>Ad</th>';
							data += '<th>Bill No</th>';
							data += '<th>Bill Date</th>';
							data += '<th>Final Total</th>';
							data += '<th>Advance</th>';
							data += '<th>Allocated Amt</th>';
							data += '<th>Allocated Round off Amt</th>';
							data += '<th>Adjust Amt</th>';
							data += '<th>Round off Amt</th>';
							data += '<th>Current Bal Amt</th>';
							data += '</tr>';

							
							$.each(resp, function(index, value)
							{
								var current_bal = parseFloat(value['om_final_total']) - parseFloat(value['om_advance']) - parseFloat(value['om_allocated_amt']) - parseFloat(value['om_roundoff']);
								if (isNaN(current_bal)) current_bal = 0;
								current_bal = current_bal.toFixed(0);

								data += '<tr id="row_'+voucher_cnt+'">';
								data += '<td style="width:5%;"><input type="checkbox" id="om_id_'+voucher_cnt+'"  value="'+value['om_id']+'" onClick="calculate_update_payment_adjust_amt()"/></td>';

								data += '<td>';
								data += '<input type="hidden" class="form-control" name="om_id[]" id="om_id_'+voucher_cnt+'" value="'+value['om_id']+'"/>';
								
								data += '<input type="hidden" class="form-control" name="vt_id[]" value="0"/>';

								data += '<input type="text" class="form-control" name="om_no[]" id="om_no_'+voucher_cnt+'" value="'+value['om_no']+'" readonly/></td>';
								data += '<td><input type="text" class="form-control" name="om_date[]" id="om_date_'+voucher_cnt+'" value="'+value['om_date']+'" readonly/></td>';

								data += '<td><input type="text" class="form-control" name="om_final_total[]" id="om_final_total_'+voucher_cnt+'" value="'+value['om_final_total']+'" readonly/></td>';
								
								data += '<td><input type="text" class="form-control" name="om_advance[]" id="om_advance_'+voucher_cnt+'" value="'+value['om_advance']+'" readonly/></td>';
								
								data += '<td><input type="text" class="form-control" name="om_allocated_amt[]" id="om_allocated_amt_'+voucher_cnt+'" value="'+value['om_allocated_amt']+'" readonly/></td>';

								data += '<td><input type="text" class="form-control" name="om_round_off[]" id="om_round_off_'+voucher_cnt+'" value="'+value['om_roundoff']+'" readonly/></td>';

								data += '<td>';
								data += '<input type="text" class="form-control" name="om_adjust_amt[]" id="om_adjust_amt_'+voucher_cnt+'" value=""/>';
								data += '</td>';

								data += '<td>';
								data += '<input type="text" class="form-control" name="om_adjust_round_off[]" id="om_adjust_round_off_'+voucher_cnt+'" value=""/>';
								data += '</td>';

								data += '<td><input type="text" class="form-control" id="om_current_bal_amt_'+voucher_cnt+'" value="'+current_bal+'" readonly/></td>';
								data += '</td>';

								data += '</tr>';

								voucher_cnt++;
							});

							data += '</table>';
						}
						else if (grp_id == 6) 
						{
							data += '<table class="table">';

							data += '<tr>';
							data += '<th>Ad</th>';
							data += '<th>Entry No</th>';
							data += '<th>Entry Date</th>';
							data += '<th>Bill No</th>';
							data += '<th>Bill Date</th>';
							data += '<th>Final Total</th>';
							data += '<th>Allocated Amt</th>';
							data += '<th>Allocated Round off Amt</th>';
							data += '<th>Adjust Amt</th>';
							data += '<th>Round off Amt</th>';
							data += '<th>Current Bal Amt</th>';
							data += '</tr>';

							
							$.each(resp, function(index, value)
							{
								var current_bal = parseFloat(value['ism_total']) -  parseFloat(value['ism_allocated_amt']);
								if (isNaN(current_bal)) current_bal = 0;
								current_bal = current_bal.toFixed(2);

								data += '<tr>';
								data += '<td>';
								data += '<input type="checkbox" id="ck_all_'+voucher_cnt+'" value="ck_all" onchange="set_adjust_amt(this,'+voucher_cnt+','+current_bal+','+len+')"  style="zoom:2" />';
								data += '</td>';
								data += '<td>';
								data += '<input type="hidden" class="form-control" name="ism_id[]" id="ism_id_'+voucher_cnt+'" value="'+value['ism_id']+'"/>';
								
								data += '<input type="hidden" class="form-control" name="vt_id[]" value="0"/>';

								data += '<input type="text" class="form-control" name="ism_entry_no[]" id="ism_entry_no_'+voucher_cnt+'" value="'+value['ism_entry_no']+'" readonly/></td>';
								data += '<td><input type="text" class="form-control" name="ism_entry_date[]" id="ism_entry_date_'+voucher_cnt+'" value="'+value['ism_entry_date']+'" readonly/></td>';

								data += '<td><input type="text" class="form-control" name="ism_bill_no[]" id="ism_bill_no_'+voucher_cnt+'" value="'+value['ism_bill_no']+'" readonly/></td>';
								data += '<td><input type="text" class="form-control" name="ism_bill_date[]" id="ism_bill_date_'+voucher_cnt+'" value="'+value['ism_bill_date']+'" readonly/></td>';


								data += '<td><input type="text" class="form-control" name="ism_total[]" id="ism_total_'+voucher_cnt+'" value="'+value['ism_total']+'" readonly/></td>';
								
								data += '<td><input type="text" class="form-control" name="ism_allocated_amt[]" id="ism_allocated_amt_'+voucher_cnt+'" value="'+value['ism_allocated_amt']+'" readonly/></td>';

								data += '<td><input type="text" class="form-control" name="ism_round_off[]" id="ism_round_off_'+voucher_cnt+'" value="'+value['ism_round_off']+'" readonly/></td>';

								data += '<td>';
								data += '<input type="text" class="form-control" name="ism_adjust_amt[]" id="ism_adjust_amt_'+voucher_cnt+'" value=""/>';
								data += '</td>';

								data += '<td>';
								data += '<input type="text" class="form-control" name="ism_adjust_round_off[]" id="ism_adjust_round_off_'+voucher_cnt+'" value=""/>';
								data += '</td>';

								data += '<td><input type="text" class="form-control" id="ism_current_bal_amt_'+voucher_cnt+'" value="'+current_bal+'" readonly/></td>';
								data += '</td>';

								data += '</tr>';

								voucher_cnt++;
							});

							data += '</table>';
						}
						else
						{
							data += '<table class="table">';

							data += '<tr>';
							data += '<th>Hisab Bill No</th>';
							data += '<th>Hisab Bill Date</th>';
							data += '<th>Final Total</th>';
							data += '<th>Allocated Amt</th>';
							data += '<th>Allocated Round off Amt</th>';
							data += '<th>Adjust Amt</th>';
							data += '<th>Round off Amt</th>';
							data += '<th>Current Bal Amt</th>';
							data += '</tr>';

							
							$.each(resp, function(index, value)
							{
								var current_bal = parseFloat(value['hm_amount']) - parseFloat(value['hm_allocated_amt']) - parseFloat(value['hm_round_off']);
								if (isNaN(current_bal)) current_bal = 0;
								current_bal = current_bal.toFixed(2);

								data += '<tr>';
								data += '<td>';
								data += '<input type="hidden" class="form-control" name="hm_id[]" id="hm_id_'+voucher_cnt+'" value="'+value['hm_id']+'"/>';
								data += '<input type="hidden" class="form-control" name="vt_id[]" value="0"/>';
								
								data += '<input type="text" class="form-control" name="om_no[]" id="om_no_'+voucher_cnt+'" value="'+value['hm_entry_no']+'" readonly/></td>';
								data += '<td><input type="text" class="form-control" name="om_date[]" id="om_date_'+voucher_cnt+'" value="'+value['hm_entry_date']+'" readonly/></td>';

								data += '<td><input type="text" class="form-control" name="om_final_total[]" id="om_final_total_'+voucher_cnt+'" value="'+value['hm_amount']+'" readonly/></td>';
								
								data += '<td><input type="text" class="form-control" name="om_allocated_amt[]" id="om_allocated_amt_'+voucher_cnt+'" value="'+value['hm_allocated_amt']+'" readonly/></td>';

								data += '<td><input type="text" class="form-control" name="om_round_off[]" id="om_round_off_'+voucher_cnt+'" value="'+value['hm_round_off']+'" readonly/></td>';


								data += '<td>';
								data += '<input type="text" class="form-control" name="om_adjust_amt[]" id="om_adjust_amt_'+voucher_cnt+'" value=""/>';
								data += '</td>';

								data += '<td>';
								data += '<input type="text" class="form-control" name="om_adjust_round_off[]" id="om_adjust_round_off_'+voucher_cnt+'" value=""/>';
								data += '</td>';

								data += '<td><input type="text" class="form-control" id="om_current_bal_amt_'+voucher_cnt+'" value="'+current_bal+'" readonly/></td>';
								data += '</td>';

								data += '</tr>';

								voucher_cnt++;
							});

							data += '</table>';
						}
					}
					else
					{
						console.log("No Data");
					}

					$("#order_details").html(data);
					$("#loading").hide();
				},
				error:function(resp) {
					console.log(resp);
				}   
			});
		}
	}

	function calculate_update_payment_adjust_amt()
	{
		var total_tr=$("#order_details table tr").length;
    	if(total_tr > 1){
	    	var amount = $("#vc_amount").val();
	    	if(isNaN(amount) || amount=='')amount=0;
	    	var total_rnd_amt=0;

	        for (var i = 2; i <= total_tr; i++) 
	        {
	        	var id= $("#order_details table tr:nth-child("+i+")").attr('id');
				var lastunderscore=id.lastIndexOf('_');
				var cnt=id.substring(lastunderscore+1);
				if ($("#om_id_"+cnt).prop("checked") == true) 
		            {
		          	   var adj_amt=$("#om_adjust_amt_"+cnt).val();
		          	   if(isNaN(adj_amt))adj_amt=0;
		          	   var rnd_amt=$("#om_adjust_round_off_"+cnt).val();
		          	   if(isNaN(rnd_amt))rnd_amt=0;
		          	   var curr_amt=$("#om_current_bal_amt_"+cnt).val();
		          	   if(isNaN(curr_amt))curr_amt=0;
		          	   // console.log(adj_amt); 
		          	   // console.log(rnd_amt);
		          	   if(adj_amt!=0 && rnd_amt!=0 )
		          	   {
	          	   			if(parseFloat(amount)>=parseFloat(curr_amt))
		          	   		{
		          	   			var adj_val=parseFloat(curr_amt)-parseFloat(rnd_amt);
		          	   			if(isNaN(adj_val))adj_val=0;
		          	   			$("#om_adjust_amt_"+cnt).val(Math.abs(adj_val));
		          	   			$("#om_adjust_round_off_"+cnt).val(Math.abs(rnd_amt));

		          	   			total_rnd_amt=parseFloat(total_rnd_amt) + parseFloat(Math.abs(rnd_amt));
		          	   			amount = parseFloat(amount) - parseFloat(Math.abs(adj_val));

		          	   		}
		          	   		else
		          	   		{
								if((parseFloat(amount)+parseFloat(rnd_amt)) <= parseFloat(curr_amt))
		          	   			{
		          	   				$("#om_adjust_amt_"+cnt).val(Math.abs(amount));
		          	   				$("#om_adjust_round_off_"+cnt).val(Math.abs(rnd_amt));

		          	   				total_rnd_amt=parseFloat(total_rnd_amt) + parseFloat(Math.abs(rnd_amt));
		          	   				amount = parseFloat(amount) - parseFloat(Math.abs(amount));
		          	   			}
		          	   			else
		          	   			{
		          	   				var adj_val=parseFloat(curr_amt)-parseFloat(Math.abs(rnd_amt));
			          	   			if(isNaN(adj_val))adj_val=0;
			          	   			$("#om_adjust_amt_"+cnt).val(Math.abs(adj_val));
			          	   			$("#om_adjust_round_off_"+cnt).val(Math.abs(rnd_amt));

			          	   			total_rnd_amt=parseFloat(total_rnd_amt) + parseFloat(Math.abs(rnd_amt));
			          	   			amount = parseFloat(amount) - parseFloat(Math.abs(adj_val));	
		          	   			}	          	   			
		          	   		}

		          	   		if((parseFloat($("#om_adjust_amt_"+cnt).val())+parseFloat($("#om_adjust_round_off_"+cnt).val())) > parseFloat(curr_amt))
		          	   		{
		          	   			let msg = 'Adjust Amt + Round off amt are not greater than current balance';
								display_alert('err',msg);
								$("body, html").animate({'scrollTop':0},1000);
								$("#om_adjust_amt_"+cnt).css({'border-color':'red'});
								$("#om_adjust_round_off_"+cnt).css({'border-color':'red'});
		          	   		}
		          	   		else
		          	   		{
		          	   			$("#om_adjust_amt_"+cnt).css({'border-color':'#CCC'});
								$("#om_adjust_round_off_"+cnt).css({'border-color':'#CCC'});	
		          	   		}

			     
		      			}
		          	   	else if(adj_amt!=0 && rnd_amt==0)
		          	   	{
		          	   		if(parseFloat(adj_amt)<=parseFloat(curr_amt))
		          	   		{
			          	   		if(parseFloat(amount)>=parseFloat(curr_amt))
			          	   		{
			          	   			var adj_val=parseFloat(curr_amt);
			          	   			if(isNaN(adj_val))adj_val=0;
			          	   			$("#om_adjust_amt_"+cnt).val(adj_val);
			          	   			
									amount = parseFloat(amount) - parseFloat(adj_val);

			          	   		}
			          	   		else
			          	   		{
									$("#om_adjust_amt_"+cnt).val(amount);
		          	   				
		          	   				amount = parseFloat(amount) - parseFloat(amount);
			          	   				          	   			
			          	   		}
			          	   		$("#om_adjust_amt_"+cnt).css({'border-color':'#CCC'});
		          	   		}
		          	   		else
		          	   		{
		          	   			let msg = 'Adjust Amt is not greater than current balance';
								display_alert('err',msg);
								$("body, html").animate({'scrollTop':0},1000);
								$("#om_adjust_amt_"+cnt).css({'border-color':'red'});
								
		          	   		}

		          	   }
		          	   else if(adj_amt==0 && rnd_amt!=0)
		          	   {
		          	   		if(parseFloat(rnd_amt)<=parseFloat(curr_amt))
		          	   		{
		          	   			$("#om_adjust_round_off_"+cnt).val(rnd_amt);

		          	   			total_rnd_amt=parseFloat(total_rnd_amt) + parseFloat(rnd_amt);
		          	   			$("#om_adjust_round_off_"+cnt).css({'border-color':'#CCC'});

		          	   		}
		          	   		else
		          	   		{
								let msg = 'Round off amt is not greater than current balance';
								display_alert('err',msg);
								$("body, html").animate({'scrollTop':0},1000);
								$("#om_adjust_round_off_"+cnt).css({'border-color':'red'});	          	   			
		          	   		}	
		          	   }
		          	   else
		          	   {
		          	   		if(parseFloat(amount)>=parseFloat(curr_amt))
		          	   		{
		          	   			var adj_val=parseFloat(curr_amt)-parseFloat(Math.abs(rnd_amt));
		          	   			if(isNaN(adj_val))adj_val=0;
		          	   			$("#om_adjust_amt_"+cnt).val(Math.abs(adj_val));
		          	   			$("#om_adjust_round_off_"+cnt).val(Math.abs(rnd_amt));

		          	   			total_rnd_amt=parseFloat(total_rnd_amt) + parseFloat(Math.abs(rnd_amt));
		          	   			amount = parseFloat(amount) - parseFloat(Math.abs(adj_val));

		          	   		}
		          	   		else
		          	   		{
								if((parseFloat(amount)+parseFloat(Math.abs(rnd_amt))) <= parseFloat(curr_amt))
		          	   			{
		          	   				$("#om_adjust_amt_"+cnt).val(amount);
		          	   				$("#om_adjust_round_off_"+cnt).val(Math.abs(rnd_amt));

		          	   				total_rnd_amt=parseFloat(total_rnd_amt) + parseFloat(rnd_amt);
		          	   				amount = parseFloat(amount) - parseFloat(amount);
		          	   			}
		          	   			else
		          	   			{
		          	   				var adj_val=parseFloat(curr_amt)-parseFloat(Math.abs(rnd_amt));
			          	   			if(isNaN(adj_val))adj_val=0;
			          	   			$("#om_adjust_amt_"+cnt).val(Math.abs(adj_val));
			          	   			$("#om_adjust_round_off_"+cnt).val(Math.abs(rnd_amt));

			          	   			total_rnd_amt=parseFloat(total_rnd_amt) + parseFloat(rnd_amt);
			          	   			amount = parseFloat(amount) - parseFloat(Math.abs(adj_val));	
		          	   			}	          	   			
		          	   		}	
		          	   }
		            }
		            else
		            {
		            	$("#om_adjust_amt_"+cnt).val(0);
			          	$("#om_adjust_round_off_"+cnt).val(0);
		            }   
	        }

	        // $("#vc_round_off").val(total_rnd_amt);
        }

	}

	function calculate_update_payment_round_amt()
	{
		// let total_adjust_amt=0;
		// let total_round_amt=0;
		let total_tr=$("#update_bal_purchase_details tr").length;
		// alert(total_tr);
		for (let i = 2; i <= total_tr; i++) 
		{
			let id=$("#update_bal_purchase_details tr:nth-child("+i+")").attr('id');
			let lastindex=id.lastIndexOf('_');
			let cnt=id.substring(lastindex+1);
			// console.log(cnt);
			let adjust_amt=$("#pm_adjust_amt_"+cnt).val();
			if(isNaN(adjust_amt) || adjust_amt=='')adjust_amt=0;
			let roundoff_amt=$("#pm_adjust_round_off_"+cnt).val();
			if(isNaN(roundoff_amt) || roundoff_amt=='')roundoff_amt=0;
			let current_amt=$("#pm_current_bal_amt_"+cnt).val();
			if(isNaN(current_amt) || current_amt=='')current_amt=0;

			let total_amt=parseFloat(adjust_amt) + parseFloat(roundoff_amt);
			if(isNaN(total_amt))total_amt=0;
			// console.log(adjust_amt);
			// console.log(roundoff_amt);

			if( total_amt > current_amt )
			{
				// console.log(total_amt);
				// console.log(current_amt);
				let msg = 'Adjust Amt + Round off amt are not greater than current balance';
				display_alert('err',msg);
				$("body, html").animate({'scrollTop':0},1000);
				$("#pm_adjust_amt_"+cnt).css({'border-color':'red'});
				$("#pm_adjust_round_off_"+cnt).css({'border-color':'red'});
			}
			else
			{
				$("#pm_adjust_amt_"+cnt).css({'border-color':'#CCC'});
				$("#pm_adjust_round_off_"+cnt).css({'border-color':'#CCC'});
			}

			// total_adjust_amt += parseFloat(adjust_amt) ;
			// total_round_amt += parseFloat(roundoff_amt) ;
		}

		// $("#vc_amount").val(total_adjust_amt);
		// $("#vc_round_off").val(total_round_amt);
	}

	function set_adjust_amt(id,cn,current_bal,len)
	{
		var sm_adjust_round_off_ts = $('#vc_round_off').val();
	    if(isNaN(sm_adjust_round_off_ts)) sm_adjust_round_off_ts = 0;

		var ck_flag = 0;
		var ck_round_flag = 0;
		for (let i = 1; i <= len; i++) {
			// console.log(123);
			// console.log(i);
			// console.log(cn);
			
			// $('#ck_all_'+cn).prop('checked',false); 

			var lfckv = document.getElementById("ck_all_"+i).checked;
	  		if(i != cn)
	  		{
		  		if (lfckv == true){
		  			ck_flag = 1;
		  		}
		  	}

		  	if(sm_adjust_round_off_ts > 0)
		  	{
		  		var ad = $('#om_adjust_round_off_'+i).val();
		  		if(isNaN(ad)) ad = 0;
		  		
		  		if(ad == sm_adjust_round_off_ts)
		  		{
		  			ck_round_flag = 1;
		  		}
		  	}
		}


	    if(id.checked == true)
	    {
	        // $('.ad_mailing_label').prop('checked',true); 
	        var vc_amount = $('#vc_amount').val();
	        if(isNaN(vc_amount)) vc_amount = 0;

	        var sm_adjust_round_off = $('#vc_round_off').val();
	        if(isNaN(sm_adjust_round_off)) sm_adjust_round_off = 0;

	        var dynamic_ad_bal = $('#dynamic_ad_bal').val();
	        if(isNaN(dynamic_ad_bal)) dynamic_ad_bal = 0;

	        if(dynamic_ad_bal >= 0)
	        {
		        if(dynamic_ad_bal == 0)
		        {
		        	if(ck_flag == 0)
		        	{
				        console.log(ck_flag);

				        if(sm_adjust_round_off > 0)
				        {
				        	// alert(111);
				        	if(sm_adjust_round_off <= current_bal)
				        	{
				        		var rf_bal = parseFloat(current_bal) - parseFloat(sm_adjust_round_off);
				        		if(isNaN(rf_bal)) rf_bal = 0;

				        		if(vc_amount < rf_bal)
				        		{
				        			// alert('aaa');
				        			var sm_adjust = vc_amount;

				        			var ad_bal = parseFloat(vc_amount) - parseFloat(rf_bal);

				        			var ad_round_bal = sm_adjust_round_off;
				        		}
				        		else
				        		{
				        			// alert('bbb');
				        			var sm_adjust = rf_bal;

				        			var ad_bal = parseFloat(vc_amount) - parseFloat(rf_bal);

				        			var ad_round_bal = sm_adjust_round_off;
				        		}
				        	}
				        	else
				        	{
				        		alert('Sorry Round off is greater than bill balance! you can not adjust bill');
				        		$('#ck_all_'+cn).prop('checked',false); 

				        		var ad_bal = dynamic_ad_bal;
				        	}
				        }
				        else
				        {
				        	if(vc_amount < current_bal)
			        		{
			        			// alert(222);
			        			var sm_adjust = vc_amount;

			        			var ad_bal = parseFloat(vc_amount) - parseFloat(current_bal);

			        			var ad_round_bal = sm_adjust_round_off;
			        		}
			        		else
			        		{
			        			// alert(333);
			        			var sm_adjust = current_bal;

			        			var ad_bal = parseFloat(vc_amount) - parseFloat(current_bal);

			        			var ad_round_bal = sm_adjust_round_off;
			        		}
				        }

				        console.log(123456);
				    }
				    else
				    {
				    	alert('Sorry! Amount is already adjusted');
						$('#ck_all_'+cn).prop('checked',false); 

						var ad_bal = dynamic_ad_bal;

						var ad_round_bal = 0;
				    }
			    }
			    else
			    {
			    	if(ck_round_flag == 0)
			    	{
			    		if(sm_adjust_round_off <= current_bal)
			        	{
			        		var rf_bal = parseFloat(current_bal) - parseFloat(sm_adjust_round_off);
			        		if(isNaN(rf_bal)) rf_bal = 0;

			        		if(dynamic_ad_bal < rf_bal)
			        		{
			        			// alert('aaa');
			        			var sm_adjust = dynamic_ad_bal;

			        			var ad_bal = parseFloat(dynamic_ad_bal) - parseFloat(rf_bal);

			        			var ad_round_bal = sm_adjust_round_off;
			        		}
			        		else
			        		{
			        			// alert('bbb');
			        			var sm_adjust = rf_bal;

			        			var ad_bal = parseFloat(dynamic_ad_bal) - parseFloat(rf_bal);

			        			var ad_round_bal = sm_adjust_round_off;
			        		}
			        	}
			        	else
			        	{
			        		alert('Sorry Round off is greater than bill balance! you can not adjust bill');
			        		$('#ck_all_'+cn).prop('checked',false); 

			        		var ad_bal = dynamic_ad_bal;
			        	}
			    	}
			    	else
			    	{
			    		if(current_bal <= dynamic_ad_bal)
		        		{
		        			var sm_adjust = current_bal;

		        			var ad_bal = parseFloat(dynamic_ad_bal) - parseFloat(current_bal);

		        			var ad_round_bal = 0;
		        		}
		        		else
		        		{
		        			var sm_adjust = dynamic_ad_bal;

		        			var ad_bal = parseFloat(dynamic_ad_bal) - parseFloat(current_bal);	

		        			var ad_round_bal = 0;
		        		}	
			    	}
			    	
			    }
			}
			else
			{
				alert('Sorry! Amount is already adjusted');
				$('#ck_all_'+cn).prop('checked',false); 

				var ad_bal = dynamic_ad_bal;

				var ad_round_bal = 0;
			}

	        $('#om_adjust_amt_'+cn).val(sm_adjust);

	        $('#om_adjust_round_off_'+cn).val(ad_round_bal);

	        $('#hm_adjust_amt_'+cn).val(sm_adjust);

	        $('#hm_adjust_round_off_'+cn).val(ad_round_bal);

	        $('#dynamic_ad_bal').val(ad_bal);
	    }
	    else
	    {
	    	var vc_amount = $('#vc_amount').val();
	    	if(isNaN(vc_amount)) vc_amount = 0;

	        var sm_adjust_round_off = $('#vc_round_off').val();
	        if(isNaN(sm_adjust_round_off)) sm_adjust_round_off = 0;

	        var dynamic_ad_bal = $('#dynamic_ad_bal').val();
	        if(isNaN(dynamic_ad_bal)) dynamic_ad_bal = 0;

	        var sm_ad_amt_revt = $('#om_adjust_amt_'+cn).val();
	        if(isNaN(sm_ad_amt_revt)) sm_ad_amt_revt = 0;

	        var sm_ad_ro_amt_revt = $('#om_adjust_round_off_'+cn).val();
	        if(isNaN(sm_ad_ro_amt_revt)) sm_ad_ro_amt_revt = 0;

	        var hm_ad_amt_revt = $('#hm_adjust_amt_'+cn).val();
	        if(isNaN(hm_ad_amt_revt)) hm_ad_amt_revt = 0;

	        var sm_ad_ro_amt_revt = $('#hm_adjust_round_off_'+cn).val();
	        if(isNaN(sm_ad_ro_amt_revt)) sm_ad_ro_amt_revt = 0;

	        if(dynamic_ad_bal >= 0)
	        {
	        	var ad_bal = parseFloat(dynamic_ad_bal) + parseFloat(sm_ad_amt_revt);

	        	if(ad_bal == vc_amount)
	        	{
	        		ad_bal = 0;
	        	}	
	        	$('#dynamic_ad_bal').val(ad_bal);
	        	
	        }
	        else
	        {
	        	var ad_bal = parseFloat(sm_ad_amt_revt);
	        	
	        	if(ad_bal == vc_amount)
	        	{
	        		ad_bal = 0;
	        	}
	        	$('#dynamic_ad_bal').val(ad_bal);
	        }

	        // $('.ad_mailing_label').prop('checked',false);
	        $('#om_adjust_amt_'+cn).val('');

	        $('#om_adjust_round_off_'+cn).val('');

	        $('#hm_adjust_amt_'+cn).val('');

	        $('#hm_adjust_round_off_'+cn).val('');
	    }
	}


	function add_voucher(id)
	{
		var check = 1;

		var acc_id = $("#vc_cash_acc_id").val();

		if($("#vc_entry_date").val() == "")
		{
			$("#vc_entry_date").css({'background-color':'yellow'});
			check = 0;
		}
		else
		{
			$("#vc_entry_date").css({'background-color':'#fff'});
		}

		if($('#vc_amount').val() < 0 || $('#vc_amount').val() == '' || isNaN(($('#vc_amount')).val()))
		{
			$("#vc_amount").css({'background-color':'yellow'});
			check = 0;
		}
		else
		{
			$("#vc_amount").css({'background-color':'#fff'});
		}

		if($('#vc_party_id').val() == 0 || $('#vc_party_id').val() == '')
		{
			$("#vc_party_id_flexselect").css({'background-color':'yellow'});
			check = 0;
		}
		else
		{
			$("#vc_party_id_flexselect").css({'background-color':'#fff'});
		}

		for (var i = 1; i < voucher_cnt; i++) 
		{
			if(($('#om_adjust_amt_'+i).val() < 0 || $('#om_adjust_amt_'+i).val() == '' || isNaN(($('#om_adjust_amt_'+i)).val())))
			{
				// $('#sm_adjust_amt_'+i).css({'background-color':'yellow'});
				// check = 0;
			}
			else
			{
				var om_adjust_amt = parseFloat($('#om_adjust_amt_'+i).val());
				if(isNaN(om_adjust_amt)) om_adjust_amt = 0;

				var om_adjust_round_off = parseFloat($('#om_adjust_round_off_'+i).val());
				if(isNaN(om_adjust_round_off)) om_adjust_round_off = 0;


				var total_adjust_amt = parseFloat(om_adjust_amt) + parseFloat(om_adjust_round_off);
				if(isNaN(total_adjust_amt)) total_adjust_amt = 0;

				var om_current_bal_amt = parseFloat($('#om_current_bal_amt_'+i).val());
				if(isNaN(om_current_bal_amt)) om_current_bal_amt = 0;

				
				if(total_adjust_amt > om_current_bal_amt)
				{
					$('#om_adjust_amt_'+i).css({'background-color':'yellow'});
					$('#om_adjust_round_off_'+i).css({'background-color':'yellow'});
					check = 2;
				}
				else
				{
					$('#om_adjust_amt_'+i).css({'background-color':'#fff'});
					$('#om_adjust_round_off_'+i).css({'background-color':'#fff'});
				}
				
			}
		}

		if(check == 0)
		{
			var msg = 'Oh snap ! You forgot to enter some information';
			display_alert('err',msg);

			$("body, html").animate({'scrollTop':0},1000);
		}
		else if(check == 2)
		{
			var msg = 'Adjust Amt should not be greater than current balance';
			display_alert('err',msg);
			$("body, html").animate({'scrollTop':0},1000);
		}
		else
		{     
			var check_validation 		   = 1;
			var check_validation_round 	   = 1;
			var total_adjust_amt 		   = 0;
			var total_adjust_round_off_amt = 0;

			var vc_amount = parseFloat($('#vc_amount').val());
			if(isNaN(vc_amount)) vc_amount = 0;

			var vc_round_off = parseFloat($('#vc_round_off').val());
			if(isNaN(vc_round_off)) vc_round_off = 0;

			for (var i = 1; i < voucher_cnt; i++) 
			{
				var om_adjust_amt = parseFloat($('#om_adjust_amt_'+i).val());
				if(isNaN(om_adjust_amt)) om_adjust_amt = 0;

				var om_adjust_round_off = parseFloat($('#om_adjust_round_off_'+i).val());
				if(isNaN(om_adjust_round_off)) om_adjust_round_off = 0;

				// console.log(om_adjust_round_off);

				total_adjust_amt = parseFloat(total_adjust_amt) + parseFloat(om_adjust_amt);
				total_adjust_round_off_amt = parseFloat(total_adjust_round_off_amt) + parseFloat(om_adjust_round_off);
			}
			
			// console.log(total_adjust_amt);

			if((total_adjust_amt != 0) || (total_adjust_round_off_amt != 0))
			{
				if((vc_amount != total_adjust_amt))
				{
					check_validation = 0;
				}
				else
				{
					check_validation = 1;
				}

				if (vc_round_off > 0) 
				{
					if((vc_round_off != total_adjust_round_off_amt))
					{
						check_validation_round = 0;
					}
					else
					{
						check_validation_round = 1;
					}
				}
				else
				{
					check_validation_round = 1; 
				}
			}
			else
			{
				check_validation = 1;
			}

			if(check_validation == 0)
			{
				var msg = 'Voucher Amt and adjust amt are not matching';
				display_alert('err',msg);

				$("body, html").animate({'scrollTop':0},1000);
			}
			else if(check_validation_round == 0)
			{
				var msg = 'Voucher round off Amt and adjust round off amt are not matching';
				display_alert('err',msg);

				$("body, html").animate({'scrollTop':0},1000);
			}
			else if((check_validation == 1) && (check_validation_round == 1))
			{
				var path = base_url+"voucherctrl/voucher_insert/"+id;   
				var form_data = $("#voucher_form").serialize();

				$("#loading").show();
				$("#sbt_btn").prop('disabled', true);
				$.ajax({
					type:'POST',
					url:path,
					data:form_data,
					success:function(resp)
					{
						console.log(resp);
						if(resp == 1)
						{
							if(id == 0)
							{
								var msg = 'Successfully added!';
								display_alert('succ',msg);
								$("html, body").animate({'scrollTop':0},1000);
								setInterval(function(){window.location.reload(); },1000);
							}
							else
							{
								var msg = 'Successfully updated!';
								display_alert('succ',msg);  
								$("html, body").animate({'scrollTop':0},1000);
								setInterval(function(){window.location.reload(); },1000);
							}
						}
						else if (resp == 2) 
						{
							var msg = 'Voucher Entery No Already Exist';
							display_alert('warn',msg);
							$("html, body").animate({'scrollTop':0},1000);
						}
						else
						{
							var msg = 'Unknown Error ! Please try again letter';
							display_alert('warn',msg);
							$("html, body").animate({'scrollTop':0},1000);
							$("#sbt_btn").prop('disabled', false);
						}
						$("#loading").hide();
					},
					error:function(resp){
						console.log(resp);
						$("#sbt_btn").prop('disabled', false);
					}   
				});
			}
			else
			{
				var msg = 'Unknown Error ! Please try again letter';
				display_alert('warn',msg);
				$("html, body").animate({'scrollTop':0},1000);
				$("#sbt_btn").prop('disabled', false);
			}
		}
	}

	function update_receipt_voucher(id)
	{
		var check = 1;
		var acc_id = $("#vc_cash_acc_id").val();

		if($("#vc_entry_no").val() == "")
		{
			$("#vc_entry_no").css({'background-color':'yellow'});
			check = 0;
		}
		else
		{
			$("#vc_entry_no").css({'background-color':'#FFF'});
		}

		if($("#vc_entry_date").val() == "")
		{
			$("#vc_entry_date").css({'background-color':'yellow'});
			check = 0;
		}
		else
		{
			$("#vc_entry_date").css({'background-color':'#FFF'});
		}

		if($("#vc_party_id").val() == 0)
		{
			$("#vc_party_id").css({'background-color':'yellow'});
			check = 0;
		}
		else
		{
			$("#vc_party_id").css({'background-color':'#FFF'});
		}

		if($('#vc_amount').val() < 0 || $('#vc_amount').val() == '' || isNaN(($('#vc_amount')).val()))
		{
			$("#vc_amount").css({'background-color':'yellow'});
			check = 0;
		}
		else
		{
			$("#vc_amount").css({'background-color':'#FFF'});
		}

		for (var i = 1; i < voucher_cnt; i++) 
		{
			if($('#om_adjust_amt_'+i).val() < 0 || $('#om_adjust_amt_'+i).val() == '' || isNaN(($('#om_adjust_amt_'+i)).val()))
			{
				// $('#sm_adjust_amt_'+i).css({'background-color':'yellow'});
				// check = 0;
			}
			else
			{
				var om_adjust_amt = parseFloat($('#om_adjust_amt_'+i).val());
				if(isNaN(om_adjust_amt)) om_adjust_amt = 0;

				var total_adjust_amt = parseFloat(om_adjust_amt);
				if(isNaN(total_adjust_amt)) total_adjust_amt = 0;

				var om_current_bal_amt = parseFloat($('#om_current_bal_amt_'+i).val());
				if(isNaN(om_current_bal_amt)) om_current_bal_amt = 0;

				if(total_adjust_amt > om_current_bal_amt)
				{
					$('#om_adjust_amt_'+i).css({'background-color':'yellow'});
					check = 2;
				}
				else
				{
					$('#om_adjust_amt_'+i).css({'background-color':'#fff'});
				}
			}
		}

		if(check == 0)
		{
			var msg = 'Oh snap ! You forgot to enter some information';
			display_alert('err',msg);

			$("body, html").animate({'scrollTop':0},1000);
		}
		else if(check == 2)
		{
			var msg = 'Adjust Amt should not be greater than current balance';
			display_alert('err',msg);
			$("body, html").animate({'scrollTop':0},1000);
		}
		else
		{     
			var check_validation 		   = 1;
			var total_adjust_amt 		   = 0;

			var vc_amount = parseFloat($('#vc_amount').val());
			if(isNaN(vc_amount)) vc_amount = 0;

			for (var i = 1; i < voucher_cnt; i++) 
			{
				var om_adjust_amt = parseFloat($('#om_adjust_amt_'+i).val());
				if(isNaN(om_adjust_amt)) om_adjust_amt = 0;

				total_adjust_amt = parseFloat(total_adjust_amt) + parseFloat(om_adjust_amt);
			}

			
			if((total_adjust_amt != 0))
			{
				if((vc_amount != total_adjust_amt))
				{
					check_validation = 0;
				}
				else
				{
					check_validation = 1;
				}
			}
			else
			{
				check_validation = 1;
			}

			if(check_validation == 0)
			{
				var msg = 'Voucher Amt and adjust amt are not matching';
				display_alert('err',msg);

				$("body, html").animate({'scrollTop':0},1000);
			}
			else if(check_validation == 1)
			{
				var path = base_url+"voucherctrl/receipt_voucher_update/"+id;   
				var form_data = $("#receipt_edit_form").serialize();

				$("#loading").show();
				$("#sbt_btn").prop('disabled', true);
				$.ajax({
					type:'POST',
					url:path,
					data:form_data,
					success:function(resp)
					{
						console.log(resp);
						if(resp == 1)
						{
							if(id == 0)
							{
								var msg = 'Successfully added!';
								display_alert('succ',msg);
								$("html, body").animate({'scrollTop':0},1000);
								setInterval(function(){window.location.reload(); },1000);
							}
							else
							{
								var msg = 'Successfully updated!';
								display_alert('succ',msg);  
								$("html, body").animate({'scrollTop':0},1000);
								setInterval(function(){window.location.reload(); },1000);
							}
						}
						else if (resp == 2) 
						{
							var msg = 'Voucher Entery No Already Exist';
							display_alert('warn',msg);
							$("html, body").animate({'scrollTop':0},1000);
						}
						else
						{
							var msg = 'Unknown Error ! Please try again letter';
							display_alert('warn',msg);
							$("html, body").animate({'scrollTop':0},1000);
							$("#sbt_btn").prop('disabled', false);
						}
						$("#loading").hide();
					},
					error:function(resp){
						console.log(resp);
						$("#sbt_btn").prop('disabled', false);
					}   
				});
			}
			else
			{
				var msg = 'Unknown Error ! Please try again letter';
				display_alert('warn',msg);
				$("html, body").animate({'scrollTop':0},1000);
				$("#sbt_btn").prop('disabled', false);
			}
		}
	}

