<?php defined('BASEPATH') OR exit('No direct script access allowed');
use Restserver\Libraries\REST_Controller;
require APPPATH . '/libraries/REST_Controller.php';
// require APPPATH . 'libraries/Format.php';
class Job_issue extends \Restserver\Libraries\REST_Controller
{
    public function __construct() {    
        parent::__construct();
        $this->load->model('api/Job_issue_model', 'IssueModel');
         $this->load->library('form_validation');
        $this->load->library('db_operations');
        $this->load->library('validateToken');
        $this->config->load('extra');
    }     

    public function get_barcode_details_post()  
    { 

        header("Access-Control-Allow-Origin: *");
        $token_data = $this->validatetoken->middleware(['validateAccessKey','validateToken']);
      
        if($token_data['status']!==TRUE){ 
            $this->response($token_data, REST_Controller::HTTP_NOT_FOUND);
            return;
        }

        $_POST = $this->security->xss_clean($_POST);
        $input_data = $this->input->raw_input_stream;
        $form_data  = json_decode($input_data, true);

        $post_data = $form_data;
        if (empty($post_data)) { 
            $message = ['status' => FALSE,'message' => "2. Invalid request.."];
            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
            return;
        }

        $_POST = $this->security->xss_clean($post_data); 
        $this->form_validation->set_rules('bm_item_code', 'Barcode', 'trim|required');
        if ($this->form_validation->run() == FALSE)
        {
            $message = array('status' => false,'error' => $this->form_validation->error_array(),'message' => validation_errors());
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        } 
        $otb_data=$this->db_operations->get_record('order_trans',['ot_barcode'=>$_POST['bm_item_code']]);
        if(empty($otb_data)){
            $message = ['status' => FALSE,'message' => "Item code not found"];
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        }  

        $output = $this->IssueModel->get_barcode_data($otb_data[0]['ot_id']); 
        if(empty($output) || $output == FALSE) 
        {
            $message = ['status' => FALSE,'message' => "No Record Available"];
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        }

        // if(!empty($output[0]['product_attachment'])){
        //     $img = base_url('public/uploads/product/'.$output[0]['product_attachment']);
        // }else{
        //     $img = base_url('public/assets/img/no_image.jpg');
        // } 

        $return_data = [  
                'apparel_name'=>$output[0]['product_name'],
                // 'apparel_image'=>$img,
                'process'=>[ 
                        [
                            'name'=> 'START',
                           'id'=>  $token_data['data']['process_id'],
                        ]
                       
                ]
        ];  

        $latest_data= $this->IssueModel->get_latest_data($otb_data[0]['ot_id']);
        // echo "<pre>";print_r($latest_data);die;
        if(!empty($latest_data)){    
            if($latest_data[0]['jrt_id'] == 0){     
                if($token_data['data']['karigar_id'] != $latest_data[0]['jim_km_id']){
                     $message = ['status' => FALSE,'message' => "Barcode already issued in ".$latest_data[0]['designation_name']];
                    $this->response($message, REST_Controller::HTTP_OK);
                    return;
                }else{ 
                     $return_data = [
                            'apparel_name'=>$output[0]['product_name'],
                            // 'apparel_image'=>$img,
                            'process'=>[ 
                                [
                                    // 'name'=> $latest_data[0]['designation_name'].'(completed)',
                                    'name'=> 'FINISHED',
                                    'id'=>  '-1',
                                ]
                            ]
                    ];
                }  
               
            }
        } 

        $message = ['status'    => true,'data' => $return_data,'message'   => "Barcode fetched successfully"];
        $this->response($message, REST_Controller::HTTP_OK);
    }

    public function get_pending_barcode_get()  
    {  
        header("Access-Control-Allow-Origin: *");
        $token_data = $this->validatetoken->middleware(['validateAccessKey','validateToken']);
        // print_r($token_data);die;
        if($token_data['status']!==TRUE){ 
            $this->response($token_data, REST_Controller::HTTP_NOT_FOUND);
            return;
        }  
        
        $output = $this->IssueModel->get_pending_barcode_data($token_data['data']['karigar_id'],$token_data['data']['process_id']); 
        if(empty($output) || $output == FALSE) 
        {
            $message = ['status' => FALSE,'message' => "No Pending Record Available"];
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        } 

        $return_data = $output;
        $message = ['status'    => true,'data' => $return_data,'message'   => "Record fetched successfully"];
        $this->response($message, REST_Controller::HTTP_OK);
    }

    public function get_pending_barcode_cnt_get()  
    {  
        header("Access-Control-Allow-Origin: *");
        $token_data = $this->validatetoken->middleware(['validateAccessKey','validateToken']);
        // print_r($token_data);die;
        if($token_data['status']!==TRUE){ 
            $this->response($token_data, REST_Controller::HTTP_NOT_FOUND);
            return;
        }  

        $output = $this->IssueModel->get_pending_barcode_data($token_data['data']['karigar_id'],$token_data['data']['process_id']); 
        $cnt =(!empty($output))?count($output):0;
        $return_data = ['count'=>$cnt];
        $message = ['status'    => true,'data' => $return_data,'message'   => "Count fetched successfully"];
        $this->response($message, REST_Controller::HTTP_OK);
    }

    public function insert_update_data_post()  
    {
        header("Access-Control-Allow-Origin: *"); 
        $token_data = $this->validatetoken->middleware(['validateAccessKey','validateToken']);
        // print_r($token_data);die;
        if($token_data['status']!==TRUE){
            $this->response($token_data, REST_Controller::HTTP_NOT_FOUND);
            return;
        }
        
        $_POST = $this->security->xss_clean($_POST);
        $input_data = $this->input->raw_input_stream;
        $form_data  = json_decode($input_data, true);

        $post_data = $form_data;
         // print_r($post_data);die;
        if (empty($post_data)) {  
            $message = ['status' => FALSE,'message' => "2. Invalid request.."];
            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
            return;
        }

        $_POST = $this->security->xss_clean($post_data); 
        $this->form_validation->set_rules('barcode', 'barcode', 'trim|required');
        $this->form_validation->set_rules('process_id', 'Process', 'trim|required');
        if ($this->form_validation->run() == FALSE)
        {
            $message = array('status' => false,'error' => $this->form_validation->error_array(),'message' => validation_errors());
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        } 
        
        $otb_data=$this->db_operations->get_record('order_trans',['ot_barcode'=>$_POST['barcode']]);
        if(empty($otb_data)){
            $message = ['status' => FALSE,'message' => "Barcode not found"];
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        }
        $master_data=[];  
        if($_POST['process_id'] != $token_data['data']['process_id']){ 
            $master_data['jrm_entry_date']     = date('Y-m-d');
            $master_data['jrm_km_id']          = $token_data['data']['karigar_id'];
            $master_data['jrm_designation']    = $token_data['data']['process_id'];
            $this->db->trans_begin();
            $master_data['jrm_entry_no']    = $this->db_operations->get_max_id_custom('job_receive_master', 'jrm_entry_no');

             $master_data['jrm_userid']         = $token_data['data']['user_id'];
             $master_data['jrm_create_date']    = date('Y-m-d H:i:s');
             $master_data['jrm_update_userid']  = $token_data['data']['user_id'];
             $master_data['jrm_update_date']    = date('Y-m-d H:i:s'); 
            $id  = $this->db_operations->data_insert('job_receive_master', $master_data);
            $msg = 'Received successfully';
            if($id < 1){ 
                $this->db->trans_rollback();
                $message = ['status' => FALSE,'message' => 'Data not added.'];
                $this->response($message, REST_Controller::HTTP_NOT_FOUND);
                return;
            }

            $result = $this->insert_update_receive_trans($_POST,$otb_data,$token_data['data'], $id);
            if(!isset($result['status'])){
                $this->db->trans_rollback();
                $message = ['status' => FALSE,'message' => $result['msg']];
                $this->response($message, REST_Controller::HTTP_NOT_FOUND);
                return;
            }   
           
            if($this->db->trans_status()===FALSE){ 
                $message = ['status' => FALSE,'message' => 'Something Wrong Please try again !!'];
                $this->response($message, REST_Controller::HTTP_NOT_FOUND);
                return;
            }

            $return_data =
                    [
                        "jrm_id"=>$id,
                        "jrm_entry_no"=>$master_data['jrm_entry_no']
                    ];
            $this->db->trans_commit(); 
            $message = ['status'    => true,'data' =>$return_data,'message'   => $msg];
            $this->response($message, REST_Controller::HTTP_OK);
            return; 

        } 
       
        $this->db->trans_begin();
        $id = ( isset($_POST['jim_id']) && !empty($_POST['jim_id']) ) ? $_POST['jim_id']:0;
        if($id==0){   
           $master_data['jim_entry_no']         = $this->db_operations->get_max_id_custom('job_issue_master', 'jim_entry_no');

             $master_data['jim_entry_date']     = date('Y-m-d'); 
             $master_data['jim_km_id']          = $token_data['data']['karigar_id'];
             $master_data['jim_designation']    = $token_data['data']['process_id'];
           
             $master_data['jim_userid']         = $token_data['data']['user_id'];
             $master_data['jim_create_date']    = date('Y-m-d H:i:s');
             $master_data['jim_update_userid']  = $token_data['data']['user_id'];
             $master_data['jim_update_date']    = date('Y-m-d H:i:s');
          
            $id  = $this->db_operations->data_insert('job_issue_master', $master_data);
            $msg = 'Issued successfully';
            if($id < 1){
                $this->db->trans_rollback();
                $message = ['status' => FALSE,'message' => 'Data not added.'];
                $this->response($message, REST_Controller::HTTP_NOT_FOUND);
                return;
            }
        }

        $result = $this->insert_update_trans($_POST,$otb_data,$token_data['data'], $id);
        if(!isset($result['status'])){
            $this->db->trans_rollback();
            $message = ['status' => FALSE,'message' => $result['msg']];
            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
            return;
        }   
       
        if($this->db->trans_status()===FALSE){ 
            $message = ['status' => FALSE,'message' => 'Something Wrong Please try again !!'];
            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
            return;
        }

        $return_data =
                    [
                        "jim_id"=>$id,
                        "jim_entry_no"=>$master_data['jim_entry_no']
                    ];
        $this->db->trans_commit(); 
        $message = ['status'    => true,'data' =>$return_data,'message'   => $msg];
        $this->response($message, REST_Controller::HTTP_OK);
    }

    public function get_max_entry_no($args,$fin_year){
        $query="SELECT ".$args['entry_no']." as max_no
                FROM job_receive_master
                WHERE ".$args['delete_status']." = 0
                AND ".$args['fin_year']." = '".$fin_year."'
                ORDER BY ".$args['entry_no']." DESC
                LIMIT 1";
        $data = $this->db->query($query)->result_array();
        return empty($data) ? 1 : $data[0]['max_no']+1;
    } 
        
    public function insert_update_trans($post_data,$otb_data,$token, $id){  

            $trans_data =[];
            $trans_data['jit_jim_id']     = $id;
            $trans_data['jit_ot_id']      = $otb_data[0]['ot_id'];

            $output = $this->IssueModel->get_barcode_data($trans_data['jit_ot_id']);
            $latest_data = $this->IssueModel->get_latest_data($trans_data['jit_ot_id']);

            if(empty($output) || $output == FALSE)return ['msg' => "Barcode Not Available"];
            if(!empty($latest_data)){    
                if($latest_data[0]['jrt_id'] == 0){ 
                    return ['msg' => $latest_data[0]['designation_name'].' (Issued)'];
                }
            }

            $st_id   = $this->db_operations->data_insert('job_issue_trans', $trans_data);
            if($st_id < 1) return ['msg' => 'Transaction not inserted.'];
            // if($this->update_barcode_master($trans_data, $st_id,$trans_data['jit_ot_id']) < 1){
            //     return ['msg' => 'barcode not updated.'];
            // } 

        return ['status' => TRUE, 'data' => TRUE, 'msg' => ''];
    } 
    
    public function insert_update_receive_trans($post_data,$otb_data,$token, $id){  

            $bm_data = $this->IssueModel->get_received_barcode($otb_data[0]['ot_id']);
            if(empty($bm_data)) return ['msg' => '1. Barcode Not found.'];

            $trans_data =[];
            $trans_data['jrt_jrm_id']     = $id;
            $trans_data['jrt_ot_id']      = $otb_data[0]['ot_id'];
            $trans_data['jrt_jim_id']     = $bm_data[0]['jit_jim_id'];
            // $trans_data['jrt_jit_id']     = $bm_data[0]['jit_id'];
            // print_r($otb_data[0]['ot_id']);

            $output = $this->IssueModel->get_received_barcode_data($otb_data[0]['ot_id']);
           
            if(empty($output)) return ['msg' => '1. Barcode not found.'];
            if($output[0]['jrt_jim_id'] != 0) return ['msg' => '1. Barcode already received from '.$output[0]['designation_name']];

            $st_id   = $this->db_operations->data_insert('job_receive_trans', $trans_data);
            if($st_id < 1) return ['msg' => 'Transaction not inserted.'];
            // if($this->update_receive_barcode_master($trans_data, $st_id) < 1){
            //     return ['msg' => 'barcode not updated.'];
            // } 

        return ['status' => TRUE, 'data' => TRUE, 'msg' => ''];
    }

   

     public function get_id($post_data){
        $record = [];
        foreach ($post_data['data'] as $key => $value) {
            array_push($record, $value['jit_id']);
        }

        return $record;
    }

    public function get_sales_person_post()
    { 
        header("Access-Control-Allow-Origin: *");
        $token_data = $this->validatetoken->middleware(['validateAccessKey','validateToken']);
        // print_r($token_data);die;
        if($token_data['status']!==TRUE){
            $this->response($token_data, REST_Controller::HTTP_NOT_FOUND);
            return;
        }

        $_POST = $this->security->xss_clean($_POST);
        $input_data = $this->input->raw_input_stream;
        $form_data  = json_decode($input_data, true);
       
        $post_data = $form_data;
        if (empty($post_data)) {
            $message = ['status' => FALSE,'message' => "2. Invalid request.."];
            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
            return;
        }

        $_POST = $this->security->xss_clean($post_data);
        $sale_person_name = (isset($_POST['sale_person_name']) && !empty($_POST['sale_person_name']))?$_POST['sale_person_name']:''; 
        $output = $this->IssueModel->get_sale_person_details($sale_person_name);
        if(empty($output) || $output == FALSE)
        {
            $message = ['status' => FALSE,'message' => "No Record Available"];
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        }

        $return_data = $output;

        $message = ['status'    => true,'data' => $return_data,'message'   => "Record ferched successfully"];
        $this->response($message, REST_Controller::HTTP_OK);
    }

/*CI controller end*/    
}