<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Voucherctrl extends CI_Controller {
	public $Vouchermdl;
	public $pagination;

	public function __construct()
	{
		parent::__construct();

		$this->load->model('Vouchermdl');
		$this->load->library('session');
		$this->load->library('upload');
		$this->load->library('pagination');
		$this->config->load('extra');
		$this->load->library('db_operations');
	}

	public function index()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$this->load->view('pages/master/index');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}
	}

	public function send_sms_for_order($mob,$msg)
    {
		$xml_data ='<?xml version="1.0"?>
		<parent> 
		<child>
		<user>STYLO FASHION</user>
		<key>dacec36fb2XX</key>
		<mobile>'.$mob.'</mobile>
		<message>'.$msg.'</message>
		<accusage>1</accusage>
		<senderid>STYLO FASHION</senderid>
		</child>
		</parent>';
		// print_r($xml_data);exit;
		$URL = "http://sms.interlinkconsultant.com/submitsms.jsp?"; 

		$ch = curl_init($URL);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
		curl_setopt($ch, CURLOPT_POSTFIELDS, "$xml_data");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$output = curl_exec($ch);
		curl_close($ch);
		// print_r($output);
    }


	/* babygolucky voucher is used */
	public function voucher()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			if($_GET['ac'] == "view") 
			{
				$config = array();
				$this->config->load('extra');
				$config = $this->config->item('pagination');
				$config['per_page'] = 20;
				
				if ($_GET['type'] == 'client') 
				{
					$config['total_rows'] = $this->Vouchermdl->get_voucher_data_count($_SESSION['fin_year']);
				}
			
				

				$config['base_url']   = base_url('voucherctrl/voucher?search=true');

				foreach ($_GET as $key => $value) {
		            if ($key != 'search' && $key != 'offset') {
		                $config['base_url'] .= '&' . $key . '=' . $value;
		            }
		        }

		        $offset = (!empty($_GET['offset'])) ? $_GET['offset'] :  0;

		        $this->pagination->initialize($config);

		        if ($_GET['type'] == 'client') 
				{
					$record = $this->Vouchermdl->get_all_voucher_data($_SESSION['fin_year'],$config['per_page'],$offset);
				}
				elseif ($_GET['type'] == 'supplier') 
				{
					$record = $this->Vouchermdl->get_all_voucher_data_supplier($_SESSION['fin_year'],$config['per_page'],$offset);
				}
				elseif ($_GET['type'] == 'karigar') 
				{
					$record = $this->Vouchermdl->get_all_voucher_data_karigar($_SESSION['fin_year'],$config['per_page'],$offset);
				}

		        
		        $record['count'] 		= $offset;
				$record['total_rows'] 	= $config['total_rows'];

				if ($_GET['type'] == 'client') 
				{
					$record['search_data'] 	= $this->config->item('voucher_search');
					$this->load->view('pages/voucher/voucher_master',$record);
				}
				if ($_GET['type'] == 'supplier') 
				{
					$record['search_data'] 	= $this->config->item('voucher_search_supplier');
					$this->load->view('pages/voucher/voucher_master_supplier',$record);
				}
				elseif ($_GET['type'] == 'karigar') 
				{
					$record['search_data'] 	= $this->config->item('voucher_search_karigar');
					$this->load->view('pages/voucher/voucher_master_karigar',$record);
				}

				// echo "<pre>";print_r($record);exit();


			}
			else if ($_GET['ac'] == "add") 
			{
				$record = $this->Vouchermdl->get_single_voucher($_SESSION['fin_year']);
				// echo "<pre>";print_r($record);exit();
				$record['voucher_type'] = $_GET['type'];
				$this->load->view('pages/voucher/voucher_form', $record);

			}
			else if ($_GET['ac'] == "update") 
			{
				$id 		= $_GET['id'];
                $vc_id 		= encrypt_decrypt("decrypt", $id, SECRET_KEY);

                // echo $vc_id;exit();

                if (!empty($vc_id)) {
                	
                	$record = $this->Vouchermdl->get_single_update_voucher($vc_id);
                	
                	// echo "<pre>";print_r($record);exit();

                	$record['voucher_type'] = $_GET['type'];
					$this->load->view('pages/voucher/voucher_form', $record);
					
                } else {
					$this->load->view('errors/error');
                }
			}
			else if ($_GET['ac'] == "print") 
			{
				$id 		= $_GET['id'];
                $vc_id 		= encrypt_decrypt("decrypt", $id, SECRET_KEY);

                if (!empty($vc_id)) {

					$record = $this->Vouchermdl->get_single_voucher_data_for_print($vc_id);

					if ($_GET['tp'] == 'bill') 
                	{
                		$this->load->view('pdfs/receipt_bill',$record);
                	}
                	// $record = $this->Vouchermdl->get_single_sale_data_for_print($vc_id);

                	// echo "<pre>";print_r($record);exit();

					// $this->load->view('pdfs/sales_print',$record);
                } else {
					$this->load->view('errors/error');
                }
			}
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}


	public function get_group_data($grp_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->Vouchermdl->get_party_list_data_groupwise($grp_id);
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function get_party_balance_status($acc_id,$grp_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->Vouchermdl->get_party_acc_status($acc_id,$grp_id);

			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function get_party_order_details($acc_id,$grp_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->Vouchermdl->get_party_order_details($acc_id,$grp_id);
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function voucher_insert($vc_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$form_data = $this->input->post();
			
			// echo"<pre>";print_r($form_data);exit;

			$voucher_data 	= array();
			$order_data 	= array();
			$voucher_trans 	= array();

			// $voucher_data['vc_entry_no']   		= $form_data['vc_entry_no'];
			$voucher_data['vc_entry_date'] 		= date('Y-m-d',strtotime($form_data['vc_entry_date']));
			$voucher_data['vc_voucher_type']    = $form_data['vc_voucher_type'];
			$voucher_data['vc_trans_type']     	= $form_data['vc_trans_type'];
			$voucher_data['vc_cash_acc_id']    	= $form_data['vc_cash_acc_id'];
			$voucher_data['vc_grp_id']         	= $form_data['vc_grp_id'];
			$voucher_data['vc_party_id']        = $form_data['vc_party_id'];
			$voucher_data['vc_amount']         	= $form_data['vc_amount'];
			$voucher_data['vc_round_off']       = $form_data['vc_round_off'];
			$voucher_data['vc_payment_type']    = $form_data['vc_payment_type'];

			if (isset($form_data['vc_bank_name'])) 
			{
				$voucher_data['vc_bank_name']         	= $form_data['vc_bank_name'];
			}

			if (isset($form_data['vc_cheq_no'])) 
			{
				$voucher_data['vc_cheq_no']         	= $form_data['vc_cheq_no'];
			}

			if (isset($form_data['vc_cheq_date'])) 
			{
				$voucher_data['vc_cheq_date']         	= $form_data['vc_cheq_date'];
			}

			if (isset($form_data['vc_card_type'])) 
			{
				$voucher_data['vc_card_type']         	= $form_data['vc_card_type'];
			}

			if (isset($form_data['vc_card_no'])) 
			{
				$voucher_data['vc_card_no']         	= $form_data['vc_card_no'];
			}

			if (isset($form_data['vc_expiry_date'])) 
			{
				$voucher_data['vc_expiry_date']         = $form_data['vc_expiry_date'];
			}


			$voucher_data['vc_notes']         	= $form_data['vc_notes'];
			$voucher_data['vc_user_id'] 	 	= $_SESSION['user_id'];
			$voucher_data['vc_fin_year'] 	 	= $_SESSION['fin_year'];
			$voucher_data['vc_update_id'] 	 	= $_SESSION['user_id'];
			$voucher_data['vc_date_create'] 	= date("Y-m-d H:i:s");

			/*order voucher*/
			if(isset($form_data['om_id']))
			{
				$order_data['om_id'] 					= $form_data['om_id'];
				$order_data['om_allocated_amt'] 		= $form_data['om_allocated_amt'];
				$order_data['om_adjust_amt'] 			= $form_data['om_adjust_amt'];
				$order_data['om_round_off'] 			= $form_data['om_round_off'];
				$order_data['om_adjust_round_off'] 		= $form_data['om_adjust_round_off'];

				$voucher_trans['vt_id']             	= $form_data['vt_id'];
				$voucher_trans['vt_om_id']             	= $form_data['om_id'];
				$voucher_trans['vt_bill_no']           	= $form_data['om_no'];
				$voucher_trans['vt_bill_date']         	= $form_data['om_date'];
				$voucher_trans['vt_final_total']       	= $form_data['om_final_total'];
				$voucher_trans['vt_adjust_amt']        	= $form_data['om_adjust_amt'];
				$voucher_trans['vt_adjust_round_off']  	= $form_data['om_adjust_round_off'];

				$grp = 5;

			}

			/*supplier voucher*/
			if(isset($form_data['ism_id']))
			{
				$order_data['ism_id'] 					= $form_data['ism_id'];
				$order_data['ism_allocated_amt'] 		= $form_data['ism_allocated_amt'];
				$order_data['ism_adjust_amt'] 			= $form_data['ism_adjust_amt'];
				$order_data['ism_round_off'] 			= $form_data['ism_round_off'];
				$order_data['ism_adjust_round_off'] 		= $form_data['ism_adjust_round_off'];

				$voucher_trans['vt_id']             	= $form_data['vt_id'];
				$voucher_trans['vt_ism_id']             	= $form_data['ism_id'];
				$voucher_trans['vt_bill_no']           	= $form_data['ism_entry_no'];
				$voucher_trans['vt_bill_date']         	= $form_data['ism_entry_date'];
				$voucher_trans['vt_final_total']       	= $form_data['ism_total'];
				$voucher_trans['vt_adjust_amt']        	= $form_data['ism_adjust_amt'];
				$voucher_trans['vt_adjust_round_off']  	= $form_data['ism_adjust_round_off'];

				$grp = 6;

			}

			/*karigar voucher */

			if(isset($form_data['hm_id']))
			{
				$order_data['hm_id'] 					= $form_data['hm_id'];
				$order_data['hm_allocated_amt'] 		= $form_data['om_allocated_amt'];
				$order_data['hm_adjust_amt'] 			= $form_data['om_adjust_amt'];
				$order_data['hm_round_off'] 			= $form_data['om_round_off'];
				$order_data['hm_adjust_round_off'] 		= $form_data['om_adjust_round_off'];

				$voucher_trans['vt_id']             	= $form_data['vt_id'];
				$voucher_trans['vt_hm_id']             	= $form_data['hm_id'];
				$voucher_trans['vt_bill_no']           	= $form_data['om_no'];
				$voucher_trans['vt_bill_date']         	= $form_data['om_date'];
				$voucher_trans['vt_final_total']       	= $form_data['om_final_total'];
				$voucher_trans['vt_adjust_amt']        	= $form_data['om_adjust_amt'];
				$voucher_trans['vt_adjust_round_off']  	= $form_data['om_adjust_round_off'];

				$grp = 7;
			}

			// echo "<pre>";print_r($voucher_data);
			// echo "<pre>";print_r($order_data);
			// echo "<pre>";print_r($voucher_trans);
			// exit();

			if ($vc_id == 0) 
			{
				$this->db->trans_begin();

				$voucher_data['vc_entry_no'] = $this->Vouchermdl->get_fin_year_wise_max_id('voucher_master','vc_entry_no','vc_fin_year',$_SESSION['fin_year']);

				// echo "<pre>";print_r($form_data);exit();
				$result = $this->db_operations->data_insert('voucher_master', $voucher_data);

				if(!empty($result))
				{
					if(!empty($voucher_trans))
					{
						$this->voucher_trans_insert_update($voucher_trans, $result);
						$this->order_update_master_data($order_data, $result, $grp);
					}

					$mob = $form_data['vc_mob_no'];
					$amt = $form_data['vc_amount'];
					
					if ($grp == 5) 
					{
						$msg = "Thank you for your Payment. We acknowledge your payment of Rs. $amt against your order. We appreciate your time, Visit again.";
						$this->send_sms_for_order($mob,$msg);
					}
					else
					{
						// $msg = "Your payment of Rs. $amt is successful.";
						// $this->send_sms_for_order($mob,$msg);
					}

					if ($this->db->trans_status() === FALSE) {
					    $this->db->trans_rollback();
					    echo 0;
					} else {
					    $this->db->trans_commit();
						echo 1;
					}	
				}
				else
				{
					echo 0;
				}
				
			}
			else
			{
				$this->db->trans_begin();

				$edit_cnt = $this->Vouchermdl->check_edit_duplicate_voucher_entry($form_data['vc_entry_no'],$_SESSION['fin_year'],$vc_id);

				if ($edit_cnt != 0) 
				{
					echo 2;
				}
				else
				{
					// echo "<pre>";print_r($form_data);exit();
					$result = $this->db_operations->data_update('voucher_master', $voucher_data, 'vc_id', $vc_id);

					if(!empty($result))
					{
						if(!empty($voucher_trans))
						{
							$this->voucher_trans_insert_update($voucher_trans, $vc_id);
							$this->order_update_master_data($order_data, $result, $grp);
						}

						if ($this->db->trans_status() === FALSE) {
						    $this->db->trans_rollback();
						    echo 0;
						} else {
						    $this->db->trans_commit();
							echo 1;
						}	
					}
					else
					{
						echo 0;
					}
				}
			}
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function voucher_trans_insert_update($voucher_trans,$vc_id)
	{
		// 0 = not avialable
		// 1 = avialable
		$voucher_trans_data = $this->db_operations->get_record('voucher_trans',array('vt_vc_id' =>$vc_id)); // get all db record first and all form data and match who is missing and those data delete by system  

		foreach ($voucher_trans_data as $key => $value) 
		{
			if (!in_array($value['vt_id'], $voucher_trans['vt_id'])) 
			{	
				/*delete transactions*/
				$del_res = $this->db_operations->delete_record('voucher_trans',array('vt_id' => $value['vt_id']));
			}
		}

		foreach ($voucher_trans['vt_id'] as $key => $value) 
		{
			if(($voucher_trans['vt_adjust_amt'][$key] > 0) || ($voucher_trans['vt_adjust_round_off'][$key] > 0))
			{
				$voucher_trans_data = array();
				$voucher_trans_data['vt_vc_id']        	= $vc_id;
				
				if (isset($voucher_trans['vt_om_id'])) 
				{
					$voucher_trans_data['vt_om_id']    	= $voucher_trans['vt_om_id'][$key];
				}
				elseif (isset($voucher_trans['vt_ism_id'])) 
				{
					$voucher_trans_data['vt_ism_id']    	= $voucher_trans['vt_ism_id'][$key];
				}
				else
				{
					$voucher_trans_data['vt_hm_id']   	= $voucher_trans['vt_hm_id'][$key];
				}

				$voucher_trans_data['vt_bill_no']      	= $voucher_trans['vt_bill_no'][$key];
				$voucher_trans_data['vt_bill_date']     = date("Y-m-d", strtotime($voucher_trans['vt_bill_date'][$key]));
				$voucher_trans_data['vt_final_total']  	= $voucher_trans['vt_final_total'][$key];
				$voucher_trans_data['vt_adjust_amt']   	= $voucher_trans['vt_adjust_amt'][$key];
				$voucher_trans_data['vt_adjust_round_off']  = $voucher_trans['vt_adjust_round_off'][$key];

				if ($value == 0) 
				{
					/*voucher transaction insert process*/
					$voucher_trans_result = $this->db_operations->data_insert('voucher_trans', $voucher_trans_data);
				} 
				else 
				{
					/*voucher transaction update process*/
					$voucher_trans_result = $this->db_operations->data_update('voucher_trans',$voucher_trans_data,'vt_id',$value);
				}
			}

		}
	}

	public function order_update_master_data($order_data,$vc_id, $grp)
	{
		if ($grp == 5) 
		{
			foreach ($order_data['om_id'] as $key => $value) 
			{
				$om_allocated_amt 			= $order_data['om_allocated_amt'][$key];
				$om_adjust_amt 				= $order_data['om_adjust_amt'][$key];
				$total_allocated_amt 		= (float)$om_allocated_amt + (float)$om_adjust_amt;

				$om_round_off_amt 			= $order_data['om_round_off'][$key];
				$om_adjust_round_off_amt 	= $order_data['om_adjust_round_off'][$key];
				$total_round_off_amt 		= (float)$om_round_off_amt + (float)$om_adjust_round_off_amt;

				$order_update = $this->db_operations->data_update('order_master',array('om_allocated_amt'=> $total_allocated_amt , 'om_roundoff' => $total_round_off_amt),'om_id',$value);
			}
		}
		elseif ($grp == 6) 
		{
			foreach ($order_data['ism_id'] as $key => $value) 
			{
				$ism_allocated_amt 			= $order_data['ism_allocated_amt'][$key];
				$ism_adjust_amt 				= $order_data['ism_adjust_amt'][$key];
				$total_allocated_amt 		= $ism_allocated_amt + $ism_adjust_amt;

				$ism_round_off_amt 			= $order_data['ism_round_off'][$key];
				$ism_adjust_round_off_amt 	= $order_data['ism_adjust_round_off'][$key];
				$total_round_off_amt 		= $ism_round_off_amt + $ism_adjust_round_off_amt;

				$order_update = $this->db_operations->data_update('inward_stock_master',array('ism_allocated_amt'=> $total_allocated_amt , 'ism_round_off' => $total_round_off_amt),'ism_id',$value);
			}
		}
		else
		{
			foreach ($order_data['hm_id'] as $key => $value) 
			{
				$om_allocated_amt 			= $order_data['hm_allocated_amt'][$key];
				$om_adjust_amt 				= $order_data['hm_adjust_amt'][$key];
				$total_allocated_amt 		= $om_allocated_amt + $om_adjust_amt;

				$om_round_off_amt 			= $order_data['hm_round_off'][$key];
				$om_adjust_round_off_amt 	= $order_data['hm_adjust_round_off'][$key];
				$total_round_off_amt 		= $om_round_off_amt + $om_adjust_round_off_amt;

				$order_update = $this->db_operations->data_update('hisab_master',array('hm_allocated_amt'=> $total_allocated_amt , 'hm_round_off' => $total_round_off_amt),'hm_id',$value);
			}
		}

	}


	public function voucher_delete($vc_id,$type)
	{
		$record['voucher_trans_data'] = $this->db_operations->get_record("voucher_trans", array('vt_vc_id' => $vc_id));
		// echo"<pre>";print_r($record);exit;

		if ($type == 5) 
		{
			foreach ($record['voucher_trans_data'] as $key => $value) 
			{
				if($value['vt_om_id'] > 0)
				{
					$vt_om_id 				= $value['vt_om_id'];
					$vt_adjust_amt 			= $value['vt_adjust_amt'];

					$vt_adjust_round_off 	= $value['vt_adjust_round_off'];

					$order_data = array();
					$order_data = $this->db_operations->get_record("order_master", array('om_id' => $value['vt_om_id']));
					
					$om_allocated_amt 		= $order_data[0]['om_allocated_amt'];
					$om_roundoff 			= $order_data[0]['om_roundoff'];

					$total_allocated_amt 	= $om_allocated_amt - $vt_adjust_amt;
					$total_roundoff_amt 	= $om_roundoff - $vt_adjust_round_off;

					$order_update = $this->db_operations->data_update('order_master',array('om_allocated_amt' => $total_allocated_amt,'om_roundoff' => $total_roundoff_amt),'om_id',$value['vt_om_id']);
				}
			}
		}
		elseif ($type == 6) 
		{
			foreach ($record['voucher_trans_data'] as $key => $value) 
			{
				if($value['vt_ism_id'] > 0)
				{
					$vt_ism_id 				= $value['vt_ism_id'];
					$vt_adjust_amt 			= $value['vt_adjust_amt'];

					$vt_adjust_round_off 	= $value['vt_adjust_round_off'];

					$inward_data = array();
					$inward_data = $this->db_operations->get_record("inward_stock_master", array('ism_id' => $value['vt_ism_id']));
					
					$ism_allocated_amt 		= $inward_data[0]['ism_allocated_amt'];
					$ism_roundoff 			= $inward_data[0]['ism_round_off'];

					$total_allocated_amt 	= $ism_allocated_amt - $vt_adjust_amt;
					$total_roundoff_amt 	= $ism_roundoff - $vt_adjust_round_off;

					$order_update = $this->db_operations->data_update('inward_stock_master',array('ism_allocated_amt' => $total_allocated_amt,'ism_round_off' => $total_roundoff_amt),'ism_id',$value['vt_ism_id']);
				}
			}
		}
		else
		{	
			foreach ($record['voucher_trans_data'] as $key => $value) 
			{
				if($value['vt_hm_id'] > 0)
				{
					$vt_hm_id 					= $value['vt_hm_id'];
					$vt_hm_adjust_amt 			= $value['vt_adjust_amt'];
					$vt_hm_adjust_round_off 	= $value['vt_adjust_round_off'];

					$hisab_data = array();
					$hisab_data = $this->db_operations->get_record("hisab_master", array('hm_id' => $value['vt_hm_id']));

					$hm_allocated_amt 		= $hisab_data[0]['hm_allocated_amt'];
					$hm_round_off 			= $hisab_data[0]['hm_round_off'];

					$hm_total_allocated_amt 	= $hm_allocated_amt - $vt_hm_adjust_amt;
					$hm_total_roundoff_amt 		= $hm_round_off - $vt_hm_adjust_round_off;

					$hisab_update = $this->db_operations->data_update('hisab_master',array('hm_allocated_amt' => $hm_total_allocated_amt,'hm_round_off' => $hm_total_roundoff_amt),'hm_id',$value['vt_hm_id']);
				}
			}
		}

		$this->db_operations->delete_record("voucher_master", array('vc_id' => $vc_id));
		$this->db_operations->delete_record("voucher_trans", array('vt_vc_id' => $vc_id));
	}


	public function receipt_voucher_update($vc_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$form_data = $this->input->post();
			
			// echo"<pre>";print_r($form_data);exit;

			$voucher_data 	= array();
			$order_data 	= array();
			$voucher_trans 	= array();

			$voucher_data['vc_entry_date'] 		= date('Y-m-d',strtotime($form_data['vc_entry_date']));
			$voucher_data['vc_notes']         	= $form_data['vc_notes'];
			$voucher_data['vc_user_id'] 	 	= $_SESSION['user_id'];
			$voucher_data['vc_fin_year'] 	 	= $_SESSION['fin_year'];
			$voucher_data['vc_update_id'] 	 	= $_SESSION['user_id'];
			$voucher_data['vc_date_create'] 	= date("Y-m-d H:i:s");

			if(isset($form_data['om_id']))
			{
				$order_data['om_id'] 					= $form_data['om_id'];
				$order_data['om_allocated_amt'] 			= $form_data['om_allocated_amt'];
				$order_data['om_adjust_amt'] 			= $form_data['om_adjust_amt'];

				$voucher_trans['vt_om_id']             = $form_data['om_id'];
				$voucher_trans['vt_bill_no']           = $form_data['om_no'];
				$voucher_trans['vt_bill_date']         = $form_data['om_date'];
				$voucher_trans['vt_final_total']       = $form_data['om_final_total'];
				$voucher_trans['vt_adjust_amt']        = $form_data['om_adjust_amt'];
				$voucher_trans['vt_adjust_round_off']  = $form_data['om_roundoff'];

			}


			$this->db->trans_begin();

			// echo "<pre>";print_r($form_data);exit();
			$result = $this->db_operations->data_update('voucher_master', $voucher_data, 'vc_id', $vc_id);

			if(!empty($result))
			{
				if (isset($form_data['om_id'])) 
				{
					$this->receipt_voucher_trans_insert($voucher_trans, $vc_id);
					$this->order_update_from_receipt_voucher($order_data, $vc_id);
				}

				if ($this->db->trans_status() === FALSE) {
				    $this->db->trans_rollback();
				    echo 0;
				} else {
				    $this->db->trans_commit();
					echo 1;
				}	
			}
			else
			{
				echo 0;
			}

		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

/**/
}
?>
