<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Orderctrl extends CI_Controller {
	public $ordermdl;
	public $pagination;

	public function __construct()
	{
		parent::__construct();

		$this->load->model('ordermdl');
		$this->load->library('session');
		$this->load->library('upload');
		$this->load->library('pagination');
		$this->config->load('extra');
		$this->load->library('db_operations');
	}

	public function index()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$this->load->view('pages/master/index');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}
	}

	public function send_sms($mob,$msg)
    {
        
		$xml_data ='<?xml version="1.0"?>
		<parent> 
		<child>
		<user>STYLO FASHION</user>
		<key>dacec36fb2XX</key>
		<mobile>'.$mob.'</mobile>
		<message>'.$msg.'</message>
		<accusage>1</accusage>
		<senderid>STYLO FASHION</senderid>
		</child>
		</parent>';
		// print_r($xml_data);exit;
		$URL = "http://sms.interlinkconsultant.com/submitsms.jsp?"; 

		$ch = curl_init($URL);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
		curl_setopt($ch, CURLOPT_POSTFIELDS, "$xml_data");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$output = curl_exec($ch);
		curl_close($ch);
		// print_r($output);
		$output_array = explode(",", $output);
		if($output_array[1]=="success")
		{
			echo 1;
		}
		else
		{
			echo 4;
		}
       
    }
    
    public function send_sms_for_order($mob,$msg)
    {
		$xml_data ='<?xml version="1.0"?>
		<parent> 
		<child>
		<user>STYLO FASHION</user>
		<key>dacec36fb2XX</key>
		<mobile>'.$mob.'</mobile>
		<message>'.$msg.'</message>
		<accusage>1</accusage>
		<senderid>STYLO FASHION</senderid>
		</child>
		</parent>';
		// print_r($xml_data);exit;
		$URL = "http://sms.interlinkconsultant.com/submitsms.jsp?"; 

		$ch = curl_init($URL);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
		curl_setopt($ch, CURLOPT_POSTFIELDS, "$xml_data");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$output = curl_exec($ch);
		curl_close($ch);
		// print_r($output);
       
    }


	public function order()
	{
		// echo "<pre>";print_r($_SESSION);exit();
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			if($_GET['ac'] == "view") 
			{
				$config = array();
				$this->config->load('extra');
				$config = $this->config->item('pagination');
				$config['per_page'] = 20;
				
				if($_SESSION['user_role_id'] == 1 || $_SESSION['user_role_id'] == 2 || $_SESSION['user_role_id'] == 4 || $_SESSION['user_role_id'] == 5): 
				$config['total_rows'] = $this->ordermdl->get_order_data_count($_SESSION['fin_year']);
				// echo '<pre>';print_r($result);exit;
				elseif($_SESSION['user_role_id'] == 3):
				$config['total_rows'] = $this->ordermdl->get_designer_order_data_count($_SESSION['fin_year'],$_SESSION['user_id']);
				endif;

				$config['base_url']   = base_url('orderctrl/order?search=true');

				foreach ($_GET as $key => $value) {
		            if ($key != 'search' && $key != 'offset') {
		                $config['base_url'] .= '&' . $key . '=' . $value;
		            }
		        }

		        $offset = (!empty($_GET['offset'])) ? $_GET['offset'] :  0;

		        $this->pagination->initialize($config);

		        if($_SESSION['user_role_id'] == 1 || $_SESSION['user_role_id'] == 2 || $_SESSION['user_role_id'] == 4 || $_SESSION['user_role_id'] == 5): 
				$record 	= $this->ordermdl->get_order_data($_SESSION['fin_year'],$config['per_page'],$offset);
				elseif($_SESSION['user_role_id'] == 3):
				$record 	= $this->ordermdl->get_designer_order_data($_SESSION['fin_year'],$config['per_page'],$offset,$_SESSION['user_id']);
				endif;

				$record['count'] 		= $offset;
				$record['total_rows'] 	= $config['total_rows'];
				$record['search_data'] 	= $this->config->item('order_search');

				// echo "<pre>";print_r($record);exit();

				$this->load->view('pages/order/order_master',$record);
			}
			else if ($_GET['ac'] == "add") 
			{
				$record = $this->ordermdl->get_data_for_order_entry($_SESSION['fin_year']);
				// echo "<pre>";print_r($record);exit();
				$this->load->view('pages/order/order_form',$record);

			}
			else if ($_GET['ac'] == "update") 
			{
				$id 		= $_GET['id'];
                $om_id 	= encrypt_decrypt("decrypt", $id, SECRET_KEY);

                if (!empty($om_id)) {
                	$record = $this->ordermdl->get_single_order_data_for_update($om_id);

                	// echo "<pre>";print_r($record);exit();
					$this->load->view('pages/order/order_form',$record);
                } else {
					$this->load->view('errors/error');
                }
			}
			else if ($_GET['ac'] == "print") 
			{
				$id 		= $_GET['id'];
				
                $om_id 		= encrypt_decrypt("decrypt", $id, SECRET_KEY);
                $c_id 		= isset($_GET['c_id']) ? $_GET['c_id'] : '';
                
                $client_id 	= encrypt_decrypt("decrypt", $c_id, SECRET_KEY);
                if (!empty($om_id)) {
                	$record = $this->ordermdl->get_single_order_data_for_print($om_id);
                	// echo "<pre>";print_r($record);exit();

                	if ($_GET['tp'] == 'adv') 
                	{
                		$this->load->view('pdfs/order_advance',$record);
                	}
                	elseif ($_GET['tp'] == 'bill') 
                	{
                		$this->load->view('pdfs/order_bill',$record);
                	}
                	elseif ($_GET['tp'] == 'measure') 
                	{
                		$record = $this->ordermdl->get_single_measure_data_for_print($om_id,$client_id);
                		// echo "<pre>";print_r($record);exit();
                		$this->load->view('pdfs/client_measer_print',$record);
                	}
                	elseif ($_GET['tp'] == 'inv') 
                	{
                		$this->load->view('pdfs/order_inv_print',$record);
                	}
                	elseif ($_GET['tp'] == 'barcode') 
                	{
                		$record = $this->ordermdl->get_stitching_barcode_data_for_print($om_id,$client_id);

                		// echo "<pre>";print_r($record);exit();
                		
                		$this->load->view('pdfs/stitching_barcode_print',$record);
                	}
                	elseif ($_GET['tp'] == 'sum') 
                	{
                		// $data = $this->ordermdl->get_order_summary_data_for_print($om_id);
                		$data = $this->ordermdl->get_done_order_trans_data($om_id);
                		
                		// echo "<pre>";print_r($data);exit();

                		$this->load->view('pdfs/order_bill_summary',$data);
                	}

                } else {
					$this->load->view('errors/error');
                }
			}
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function get_all_acc_details($client_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_customer_record($client_id);
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function get_apparel_data($app_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_apparel_record($app_id);
			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function get_apparel_data_package_fabric($id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_apparel_data_package_fabric($id);
			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function get_measurement_data_by_apparel_order($app_id,$client_id)
	{
		$user_id = $this->session->userdata('user_id');

		if(!empty($user_id))
		{
			$post = $this->input->post();
			$otm_id = $post['otm_id1'];
			// print_r($otm_id);exit;
			$data = [];
			$query1= "SELECT 
                app.*, aat.aat_apparel_id
                FROM apparel_apparel_trans aat
                INNER JOIN apparel_master app ON(app.app_id = aat.aat_apparel_id)
                WHERE 1
                AND aat.apparel_id = $app_id
				ORDER BY aat.aat_id";
				// echo $query1;exit;
			$record['apparel_data'] =$this->db->query($query1)->result_array();
			// echo "<pre>"; print_r($record); die;
			if(!empty($record['apparel_data'])){
				foreach($record['apparel_data'] as $key => $value) {
					$single_otm_id = 0;
					if(!empty($otm_id))
					{
						$otm_single_id = explode(',',$otm_id);
						foreach ($otm_single_id as $key2 => $value2) 
						{
							$otm_data = $this->db_operations->get_record('order_trans_measurement',['otm_id' => $value2,'otm_app_id' => $value['app_id'],'otm_client_id' => $client_id]);
							if(!empty($otm_data))
							{
								$single_otm_id = $value2;
							}
						}
					}

					$maap = $this->ordermdl->get_measurement_data_by_apparel_order($value['app_id'],$client_id,$single_otm_id);

					$style = $this->ordermdl->get_measurement_data_by_apparel_style_order($value['app_id'],$client_id,$single_otm_id);
					$style_parameter = $this->ordermdl->get_style_by_apparel($value['app_id']);
					$maap_dropdown = $this->ordermdl->get_apparel_list_clientwise($client_id);

					if(empty($maap) && empty($style)) {echo json_encode(['status'=>false,'data'=>[],'msg' => '2. Measurement not found.']);
						return;
					}

					array_push($data, ['apparel_data' => $value, 'measurement_data' => $maap, 'style_data' => $style, 'style_parameter' => $style_parameter, 'maap_dropdown' => $maap_dropdown]);
				}
			}
			else{
				$query1= "SELECT 
                app.*
                FROM apparel_master app
                WHERE 1
                AND app.app_id = $app_id
				ORDER BY app.app_id";
				$record['app_data'] =$this->db->query($query1)->result_array();
				 // echo "<pre>"; print_r($record); die;
				foreach($record['app_data'] as $key => $value) {

					$single_otm_id = 0;
					if(!empty($otm_id))
					{
						$otm_single_id = explode(',',$otm_id);
						foreach ($otm_single_id as $key2 => $value2) 
						{
							$otm_data = $this->db_operations->get_record('order_trans_measurement',['otm_id' => $value2,'otm_app_id' => $value['app_id'],'otm_client_id' => $client_id]);
							if(!empty($otm_data))
							{
								$single_otm_id = $value2;
							}
						}
					}

					$maap = $this->ordermdl->get_measurement_data_by_apparel_order($value['app_id'],$client_id,$single_otm_id);
					$style = $this->ordermdl->get_measurement_data_by_apparel_style_order($value['app_id'],$client_id,$single_otm_id);
					$style_parameter = $this->ordermdl->get_style_by_apparel($value['app_id']);

					$maap_dropdown = $this->ordermdl->get_apparel_list_clientwise($client_id);
					
					if(empty($maap) && empty($style)){
						echo json_encode(['status'=>false,'data'=>[],'msg' => '2. Measurement not found.']);
						return;
					} 

					array_push($data, ['apparel_data' => $value, 'measurement_data' => $maap, 'style_data' => $style, 'style_parameter' => $style_parameter, 'maap_dropdown' => $maap_dropdown]);
					
				}
			}
			// echo "<pre>"; print_r($data); die;
			echo json_encode(['status'=>true,'data'=>$data,'msg'=>'']);
		} else {
			redirect('loginctrl/logout');
		}
	}

	// public function client_insert_from_order($client_id)
	// {
	// 	$user_id = $this->session->userdata('user_id');
	// 	if(!empty($user_id)) 
	// 	{
	// 		$form_data = $this->input->post();
	// 		// echo "<pre>";print_r($form_data);exit();
	// 		/*client data*/
	// 		// echo "<pre>"; print_r($form_data); exit();

	// 		$client_data = array();
	// 		$client_data['client_name'] 	= trim($form_data['client_name']);
	// 		if($client_id == 0) 
	// 		{
	// 			$this->db->trans_begin();
	// 			$cnt = $this->db_operations->get_cnt('client_master',array('client_name' => $form_data['client_name']));

	// 			if ($cnt != 0) 
	// 			{
	// 				$response['resp'] = 2;
	// 				echo json_encode($response);
	// 			}
	// 			else 
	// 			{
	// 				$client_data['client_userid'] 		 = $_SESSION['user_id'];
	// 				$client_data['client_cdate'] 		 = date('Y-m-d');
	// 				$client_data['client_modify_userid'] = $_SESSION['user_id'];
	// 				$client_id = $this->db_operations->data_insert('client_master', $client_data);
	// 				// echo "<pre>";print_r($client_id);exit;
	// 				// echo "<pre>";print_r(isset($form_data['ct_id']));exit;

	// 				if (!empty($client_id)) 
	// 				{
	// 					/*insert data to purchase_trans table*/
	// 					if(isset($form_data['ct_id']))
	// 					{
	// 						$ct_id 	= $this->insert_update_client_trans($form_data, $client_id);
	// 						if (!empty($ct_id)) 
	// 						{
	// 							if ($this->db->trans_status() === FALSE) 
	// 							{
	// 							    $this->db->trans_rollback();
	// 							    $response['resp'] = 0;
	// 								echo json_encode($response);						    						
	//     						} 
	//     						else 
	//     						{
	// 							    $this->db->trans_commit();
	// 							    $response['resp'] = 1;
	// 							    $response['last_id'] = encrypt_decrypt("encrypt", $client_id, SECRET_KEY);
	// 								echo json_encode($response);						   
	// 							}
	// 						}
	// 						else
	// 						{
	// 							$this->db->trans_rollback();
	// 						    $response['resp'] = 0;
	// 							echo json_encode($response);
	// 						}
	// 					}	
	// 					else
	// 					{
	// 						if ($this->db->trans_status() === FALSE) 
	// 						{
	// 						    $this->db->trans_rollback();
	// 						    $response['resp'] = 0;
	// 							echo json_encode($response);						    						
    // 						} 
    // 						else 
    // 						{
	// 						    $this->db->trans_commit();
	// 						    $response['resp'] = 1;
	// 						    $response['last_id'] = encrypt_decrypt("encrypt", $client_id, SECRET_KEY);
	// 							echo json_encode($response);						   
	// 						}
	// 					}					
	// 				}
	// 			}
	// 		} 
	// 		else 
	// 		{
	// 			$this->db->trans_begin();
	// 			// $edit_cnt = $this->db_operations->get_cnt('client_master',array('client_name'=>$form_data['client_name'],'client_id !='=>$client_id));
	// 			// 	echo "<pre>";print_r($edit_cnt);exit;

	// 			// if ($edit_cnt != 0) 
	// 			// {
	// 			// 	$response['resp'] = 2;
	// 			// 	echo json_encode($response);
	// 			// }
	// 			// else
	// 			// {
	// 				$client_data['client_modify_userid'] = $_SESSION['user_id'];
	// 				$client_data['client_modify_date'] 	 = date('Y-m-d H:i:s');
	// 				$result_id = $this->db_operations->data_update('client_master', $client_data, 'client_id', $client_id);
	// 				// echo "<pre>";print_r($client_id);exit;
	// 				// echo "<pre>";print_r(isset($form_data['ct_id']));exit;

	// 				if (!empty($result_id)) 
	// 				{
	// 					/*insert data to purchase_trans table*/
	// 					if(isset($form_data['ct_id']))
	// 					{
	// 						$ct_id 	= $this->insert_update_client_trans($form_data, $client_id);
	// 						if (!empty($ct_id)) 
	// 						{
	// 							if ($this->db->trans_status() === FALSE) 
	// 							{
	// 							    $this->db->trans_rollback();
	// 							    $response['resp'] = 0;
	// 								echo json_encode($response);						    						
	//     						} 
	//     						else 
	//     						{
	// 							    $this->db->trans_commit();
	// 							    $response['resp'] = 1;
	// 							    $response['last_id'] = encrypt_decrypt("encrypt", $client_id, SECRET_KEY);
	// 								echo json_encode($response);						   
	// 							}
	// 						}
	// 						else
	// 						{

	// 							$this->db->trans_rollback();
	// 						    $response['resp'] = 0;
	// 							echo json_encode($response);
	// 						}
	// 					}	
	// 					else
	// 					{
	// 						$ct_cnt = $this->db_operations->get_cnt('client_trans', ['ct_client_id'=>$client_id]);
	// 						if($ct_cnt != 0)
	// 						{
	// 							$this->db_operations->delete_record('client_trans',array('ct_client_id'=>$client_id));
	// 						}
	// 						if ($this->db->trans_status() === FALSE) 
	// 						{
	// 						    $this->db->trans_rollback();
	// 						    $response['resp'] = 0;
	// 							echo json_encode($response);						    						
    // 						} 
    // 						else 
    // 						{
	// 						    $this->db->trans_commit();
	// 						    $response['resp'] = 1;
	// 						    $response['last_id'] = encrypt_decrypt("encrypt", $client_id, SECRET_KEY);
	// 							echo json_encode($response);						   
	// 						}
	// 					}					
	// 				}
	// 			// }
	// 		}
	// 	} 
	// 	else {
	// 		redirect('loginctrl/logout');		
	// 	}
	// }

	public function client_insert_from_order($client_id,$otm)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$form_data = $this->input->post();
			// echo "<pre>";print_r($form_data);exit();
			if(empty($form_data)){
				echo json_encode(['status' => FALSE, 'data' => [], 'msg' => 'Form data is empty.']);
				return;
			}
			$client_data = array();
			$client_data['client_name'] 	= trim($form_data['client_name']);
			
			$this->db->trans_begin();
			if($client_id == 0) 
			{
				$cnt = $this->db_operations->get_cnt('client_master',array('client_name' => $form_data['client_name'],'client_mobile1' => $form_data['client_mobile1']));
				if(!empty($cnt)){
					echo json_encode(['status' => FALSE, 'data' => [], 'msg' => 'Client name already exist.']);
					return;
				}
				else 
				{
					$client_data['client_userid'] 		 = $_SESSION['user_id'];
					$client_data['client_cdate'] 		 = date('Y-m-d');
					$client_data['client_modify_userid'] = $_SESSION['user_id'];
					$client_id = $this->db_operations->data_insert('client_master', $client_data);
					
					if($client_id < 1){
						$this->db->trans_rollback();
						echo json_encode(['status' => FALSE, 'data' => [], 'msg' => 'Client data not added.']);
						return;
					}
					$msg="Inward data added successfully.";			
				}
			} 
			else 
			{
				$client_data['client_modify_userid'] = $_SESSION['user_id'];
				$client_data['client_modify_date'] 	 = date('Y-m-d H:i:s');
				if($this->db_operations->data_update('client_master', $client_data, 'client_id', $client_id) <1 ){
					$this->db->trans_rollback();
					echo json_encode(['status' => FALSE, 'data' => [], 'msg' => 'Client data not updated.']);
					return;
				}
				$msg="Inward data update successfully.";	
			}	
			// echo "<pre>";print_r($form_data);exit();
			/*insert data to purchase_trans table*/
			if(isset($form_data['ct_id']))	
			{
				$result = $this->insert_update_client_trans($form_data, $client_id);
				if(!$result['status']){
					$this->db->trans_rollback();
					echo json_encode(['status' => $result['status'], 'data' => $result['data'], 'msg' => $result['msg']]);
					return;
				}
			}
			$otm_id = '';
			if(isset($form_data['otm_id']))
			{
				$measurment_result 	= $this->insert_update_order_measurement($form_data,$client_id);
				if(!$measurment_result['status']){
					$this->db->trans_rollback();
					echo json_encode(['status' => $measurment_result['status'], 'data' => $measurment_result['data'], 'msg' => $result['msg']]);
					return;
				}
				// echo"<pre>";print_r($measurment_result);exit;
				$otm_id = $measurment_result['data'];
			}
			if($this->db->trans_status() === FALSE){
			    $this->db->trans_rollback();
			    echo json_encode(['status' => FALSE, 'data' => [], 'msg' => 'Transaction Rollback.']);
				return;
		    }
		    $this->db->trans_commit();
			$data['client_id'] = encrypt_decrypt("encrypt", $client_id, SECRET_KEY);
			$data['otm_id'] = $otm_id;
			echo json_encode(['status' => TRUE, 'data' => $data,  'msg' => $msg]);	
		} 
		else {
			redirect('loginctrl/logout');		
		}
	}
	public function insert_update_client_trans($form_data, $client_id)
	{	
		// 0 = not avialable
		// 1 = avialable
		$flag = 0;

		$client_trans_data = $this->db_operations->get_record('client_trans',array('ct_client_id' => $client_id)); // get all db record first and all form data and match who is missing and those data delete by system  
		// unset($form_data['otm_id']);
		foreach ($form_data as $key => $value)
		{
			$key = preg_replace("/[\s\-\.]/", "_", $key);
			if(is_array($value))
			{
				$field_name = $this->db->query("SHOW COLUMNS FROM client_trans like '".$key."'")->result_array();
				if (empty($field_name)) 
				{
					$this->db->query("ALTER TABLE client_trans ADD ".$key." varchar(200) NOT NULL  ");					
				}
			}
		}


		// exit();
		foreach ($form_data['ct_id'] as $key => $value)
		{
			// echo "<pre>"; print_r($form_data); exit;

			$client_trans_data = array();
			$client_trans_data['ct_client_id']	= $client_id;
			$client_trans_data['ct_app_id']		= $form_data['ct_app_id'][$key];
			$client_trans_data['ct_mm_id']		= $form_data['ct_mm_id'][$key];


			if($form_data['ct_app_id'][$key] == 2 || $form_data['ct_app_id'][$key] == 4|| $form_data['ct_app_id'][$key] == 9 || $form_data['ct_app_id'][$key] == 12 || $form_data['ct_app_id'][$key] == 15  || $form_data['ct_app_id'][$key] == 16  || $form_data['ct_app_id'][$key] == 18)
			{
				$client_trans_data['ct_f1']		= (isset($form_data['ct_f1'][$key])) ? $form_data['ct_f1'][$key] : '';
				$client_trans_data['ct_f2']		= (isset($form_data['ct_f2'][$key])) ? $form_data['ct_f2'][$key] : '';
				$client_trans_data['ct_f3']		= (isset($form_data['ct_f3'][$key])) ? $form_data['ct_f3'][$key] : '';
				$client_trans_data['ct_f4']		= (isset($form_data['ct_f4'][$key])) ? $form_data['ct_f4'][$key] : '';
				$client_trans_data['ct_b1']		= (isset($form_data['ct_b1'][$key])) ? $form_data['ct_b1'][$key] : '';
				$client_trans_data['ct_b2']		= (isset($form_data['ct_b2'][$key])) ? $form_data['ct_b2'][$key] : '';
				$client_trans_data['ct_b3']		= (isset($form_data['ct_b3'][$key])) ? $form_data['ct_b3'][$key] : '';
				$client_trans_data['ct_b4']		= (isset($form_data['ct_b4'][$key])) ? $form_data['ct_b4'][$key] : '';

				$client_trans_data['ct_mundo']	= (isset($form_data['ct_mundo'][$key])) ? $form_data['ct_mundo'][$key] : '';
				$client_trans_data['ct_loosing']= (isset($form_data['ct_loosing'][$key])) ? $form_data['ct_loosing'][$key] : '';
			
				$client_trans_data['ct_alag_collar']= (isset($form_data['ct_alag_collar'][$key])) ? $form_data['ct_alag_collar'][$key] : '';
				$client_trans_data['ct_cutway']= (isset($form_data['ct_cutway'][$key])) ? $form_data['ct_cutway'][$key] : '';
				$client_trans_data['ct_astro']= (isset($form_data['ct_astro'][$key])) ? $form_data['ct_astro'][$key] : '';
				$client_trans_data['ct_charlie']= (isset($form_data['ct_charlie'][$key])) ? $form_data['ct_charlie'][$key] : '';
				$client_trans_data['ct_chinese']= (isset($form_data['ct_chinese'][$key])) ? $form_data['ct_chinese'][$key] : '';

				$client_trans_data['ct_alag_collar_value']= (isset($form_data['ct_alag_collar_value'][$key])) ? $form_data['ct_alag_collar_value'][$key] : '';
				$client_trans_data['ct_cutway_value']= (isset($form_data['ct_cutway_value'][$key])) ? $form_data['ct_cutway_value'][$key] : '';
				$client_trans_data['ct_astro_value']= (isset($form_data['ct_astro_value'][$key])) ? $form_data['ct_astro_value'][$key] : '';
				$client_trans_data['ct_charlie_value']= (isset($form_data['ct_charlie_value'][$key])) ? $form_data['ct_charlie_value'][$key] : '';
				$client_trans_data['ct_chinese_value']= (isset($form_data['ct_chinese_value'][$key])) ? $form_data['ct_chinese_value'][$key] : '';

			}
			if($form_data['ct_app_id'][$key] == 1 || $form_data['ct_app_id'][$key] == 5  || $form_data['ct_app_id'][$key] == 19)
			{
				$client_trans_data['ct_f_b']	= (isset($form_data['ct_f_b'][$form_data['ct_mm_id'][$key]])) ? $form_data['ct_f_b'][$form_data['ct_mm_id'][$key]] : '';
				$client_trans_data['ct_aagal_thi_low']	= (isset($form_data['ct_aagal_thi_low'][$key])) ? $form_data['ct_aagal_thi_low'][$key] : '';
			}


			// $client_trans_data['ct_notes'] 	= $form_data['ct_notes'][$form_data['ct_mm_id'][$key]];
			$client_trans_data['ct_notes'] 		= $form_data['ct_notes'][$form_data['ct_mm_id'][$key]];
			$client_trans_data['ct_notes_maap'] = $form_data['ct_notes_maap'][$form_data['ct_mm_id'][$key]];
			// echo "<pre>"; print_r($client_trans_data); exit;

			$maap_data = $this->ordermdl->get_measurement_data_by_apparel($form_data['ct_mm_id'][$key]);

			$style_data = $this->ordermdl->get_measurement_data_by_apparel_style($form_data['ct_mm_id'][$key]);

			$style_p = $this->ordermdl->get_style_parameter_data_by_apparel_style($form_data['ct_app_id'][$key]);
			// echo "<pre>"; print_r($maap_data); 
			// echo "<pre>"; print_r($client_trans_data); exit;

			if(!empty($maap_data))
			{
				foreach ($maap_data as $value1) 
				{
					// $col_name = strtolower(trim($value1['maap_name'], ' '));
					// $col_name = str_replace('-', '_', $col_name);
					// $col_name = str_replace(' ', '_', $col_name);
					$col_name = preg_replace("/[\s\-\.]/", "_", strtolower(trim($value1['maap_name'])));

					// echo "<pre>"; print_r($col_name); 

					if(array_key_exists('ct_'.$col_name, $form_data))
					{

						if(array_key_exists($form_data['ct_mm_id'][$key], $form_data['ct_'.$col_name]))
						{
							$client_trans_data['ct_'.$col_name] = empty($form_data['ct_'.$col_name][$form_data['ct_mm_id'][$key]]) ? '' : $form_data['ct_'.$col_name][$form_data['ct_mm_id'][$key]];
							// echo "<pre>"; print_r($col_name); 
							// echo "<pre>";print_r($client_trans_data);
						}
					}						
				}
			}
			// exit;
			if(!empty($style_data))
			{
				foreach ($style_data as $value2) 
				{
					// $col_name1 = strtolower(trim($value2['style_name'], ' '));
					// $col_name1 = str_replace('-', '_', $col_name1);
					// $col_name1 = str_replace(' ', '_', $col_name1);
					// $col_name1 = preg_replace("/[\s\-\.]/", "_", strtolower(trim($value2['style_name']))); hide by mamta

					$col_name1 = preg_replace("/[\s-.&\/\\<>#,+\"'\$~%.()?*:{}=]/", "_", strtolower(trim($value2['style_name'])));


					$client_trans_data1 = $this->db_operations->get_record('client_trans',array('ct_id' => $value));  
					// echo "<pre>"; print_r($client_trans_data1[0]); exit;
					
					if(!empty($client_trans_data1))
					{ 
						if(array_key_exists('ct_'.$col_name1, $client_trans_data1[0]))
	                    {
	                    	$check_update = array();
	                    	$check_update['ct_'.$col_name1] = "";
	                    // echo "<pre>"; print_r($check_update); exit;
	                    	$this->db_operations->data_update('client_trans', $check_update, 'ct_id', $value);
	                    }
					}
					

							// echo "<pre>"; print_r($col_name1); 

					if(array_key_exists('ct_'.$col_name1, $form_data))
					{
						if(array_key_exists($form_data['ct_mm_id'][$key], $form_data['ct_'.$col_name1]))
						{
							$client_trans_data['ct_'.$col_name1] = empty($form_data['ct_'.$col_name1][$form_data['ct_mm_id'][$key]]) ? '' : $form_data['ct_'.$col_name1][$form_data['ct_mm_id'][$key]];
							// echo "<pre>"; print_r($col_name); 
							// echo "<pre>";print_r($client_trans_data);
						}
					}						
				}
			}
			if(!empty($style_p))
			{
				foreach ($style_p as $value3) 
				{
					$col_name1 = preg_replace("/[\s-.&\/\\<>#,+\"'\$~%.()?*:{}=]/", "_", strtolower(trim($value3['style_name'])));

					$client_trans_data1 = $this->db_operations->get_record('client_trans',array('ct_id' => $value));  
					// echo "<pre>"; print_r($client_trans_data1[0]); exit;
					
					if(!empty($client_trans_data1))
					{ 
						if(array_key_exists('ct_'.$col_name1.'_id', $client_trans_data1[0]))
	                    {
	                    	$check_update = array();
	                    	$check_update['ct_'.$col_name1.'_id'] = "";
	                    // echo "<pre>"; print_r($check_update); exit;
	                    	$this->db_operations->data_update('client_trans', $check_update, 'ct_id', $value);
	                    }

	                    if(array_key_exists('ct_'.$col_name1.'_value', $client_trans_data1[0]))
	                    {
	                    	$check_update = array();
	                    	$check_update['ct_'.$col_name1.'_value'] = "";
	                    // echo "<pre>"; print_r($check_update); exit;
	                    	$this->db_operations->data_update('client_trans', $check_update, 'ct_id', $value);
	                    }
					}

					// echo "<pre>"; print_r($col_name1); 

					if(array_key_exists('ct_'.$col_name1.'_id', $form_data))
					{
						if(array_key_exists($form_data['ct_mm_id'][$key], $form_data['ct_'.$col_name1.'_id']))
						{
							$client_trans_data['ct_'.$col_name1.'_id'] = empty($form_data['ct_'.$col_name1.'_id'][$form_data['ct_mm_id'][$key]]) ? '' : $form_data['ct_'.$col_name1.'_id'][$form_data['ct_mm_id'][$key]];
							// echo "<pre>"; print_r($col_name); 
							// echo "<pre>";print_r($client_trans_data);
						}
					}

					if(array_key_exists('ct_'.$col_name1.'_value', $form_data))
					{
						if(array_key_exists($form_data['ct_mm_id'][$key], $form_data['ct_'.$col_name1.'_value']))
						{
							$client_trans_data['ct_'.$col_name1.'_value'] = empty($form_data['ct_'.$col_name1.'_value'][$form_data['ct_mm_id'][$key]]) ? '' : $form_data['ct_'.$col_name1.'_value'][$form_data['ct_mm_id'][$key]];
							// echo "<pre>"; print_r($col_name); 
							// echo "<pre>";print_r($client_trans_data);
						}
					}						
				}
			}

			// echo "<pre>";print_r($value);exit;	

			// $ct_trans = $this->db_operations->get_record('client_trans',array('ct_client_id' => $client_id,'ct_app_id' => $form_data['ct_app_id'][$key] ));

			// echo "<pre>";print_r($client_trans_data);exit;	
			// if(!empty($ct_trans))
			// {
			// 	$result = $this->db_operations->data_update('client_trans',$client_trans_data,'ct_id',$ct_trans[0]['ct_id']);
			// }
			// else
			// {
			// 	$result = $this->db_operations->data_insert('client_trans', $client_trans_data);
			// }

			if ($value == 0)
			{
				$result = $this->db_operations->data_insert('client_trans', $client_trans_data);
				if($result < 1)
				{
					return ['status'=>false, 'data'=>[], 'msg'=>'Client Trans not inserted !!'];
				}
			}
			else
			{
				$result = $this->db_operations->data_update('client_trans',$client_trans_data,'ct_id',$value);
				if($result < 1)
				{
					return ['status'=>false, 'data'=>[], 'msg'=>'Client Trans not updated !!'];
				}
			}	
		}

		// if(!empty($result))
		// {
		// 	$flag = 1;
		// }
		
		return ['status'=>true, 'data'=>[], 'msg'=>''];
	}

	public function insert_update_order_measurement($form_data, $client_id)
	{	
		$new_form_data=array();
		// unset($form_data['ct_id']);
		foreach ($form_data as $key => $value)
		{
			// $key = str_replace('-', '_', $key);
			$key = preg_replace("/[\s-.&\/\\<>#,+\"'\$~%.()?*:{}=]/", "_", $key);
			if(is_array($value))
			{	
				if(explode("_",$key)[0] != 'otm'){
					$key = substr_replace($key,"otm",0,2);
				}
				$field_name = $this->db->query("SHOW COLUMNS FROM order_trans_measurement like '".$key."'")->result_array();
				if (empty($field_name)) 
				{
					// echo "<pre>";print_r($key);
					if($this->db->query("ALTER TABLE order_trans_measurement ADD ".$key." varchar(200) NOT NULL  ") < 1){
						return ['status' => FALSE, 'data' => FALSE, 'msg' => 'Order Trans measurement colunm name '.$field_name.' not updated.'];
					}	
				}
			}
			$new_form_data[$key]=$value;
		}
		// echo"<pre>";print_r($new_form_data);exit;
		$otm_ids = '';
		foreach ($new_form_data['otm_id'] as $key => $value)
		{
			$order_trans_mesurement_data = array();
			
			$order_trans_mesurement_data['otm_client_id']	= $client_id;
			$order_trans_mesurement_data['otm_app_id']		= $new_form_data['otm_app_id'][$key];
			$order_trans_mesurement_data['otm_mm_id']		= $new_form_data['otm_mm_id'][$key];
			// $order_trans_mesurement_data['otm_karigar_id']	= $new_form_data['otm_karigar_id'][$key];

			if($new_form_data['otm_app_id'][$key] == 2 || $new_form_data['otm_app_id'][$key] == 4|| $new_form_data['otm_app_id'][$key] == 9|| $new_form_data['otm_app_id'][$key] == 12)
			{
				$order_trans_mesurement_data['otm_f1']		= (isset($new_form_data['otm_f1'][$key])) ? $new_form_data['otm_f1'][$key] : '';
				$order_trans_mesurement_data['otm_f2']		= (isset($new_form_data['otm_f2'][$key])) ? $new_form_data['otm_f2'][$key] : '';
				$order_trans_mesurement_data['otm_f3']		= (isset($new_form_data['otm_f3'][$key])) ? $new_form_data['otm_f3'][$key] : '';
				$order_trans_mesurement_data['otm_f4']		= (isset($new_form_data['otm_f4'][$key])) ? $new_form_data['otm_f4'][$key] : '';
				$order_trans_mesurement_data['otm_b1']		= (isset($new_form_data['otm_b1'][$key])) ? $new_form_data['otm_b1'][$key] : '';
				$order_trans_mesurement_data['otm_b2']		= (isset($new_form_data['otm_b2'][$key])) ? $new_form_data['otm_b2'][$key] : '';
				$order_trans_mesurement_data['otm_b3']		= (isset($new_form_data['otm_b3'][$key])) ? $new_form_data['otm_b3'][$key] : '';
				$order_trans_mesurement_data['otm_b4']		= (isset($new_form_data['otm_b4'][$key])) ? $new_form_data['otm_b4'][$key] : '';

				$order_trans_mesurement_data['otm_mundo']	= (isset($new_form_data['otm_mundo'][$key])) ? $new_form_data['otm_mundo'][$key] : '';
				$order_trans_mesurement_data['otm_loosing']= (isset($new_form_data['otm_loosing'][$key])) ? $new_form_data['otm_loosing'][$key] : '';
			
				$order_trans_mesurement_data['otm_alag_collar']= (isset($new_form_data['otm_alag_collar'][$key])) ? $new_form_data['otm_alag_collar'][$key] : '';
				$order_trans_mesurement_data['otm_cutway']= (isset($new_form_data['otm_cutway'][$key])) ? $new_form_data['otm_cutway'][$key] : '';
				$order_trans_mesurement_data['otm_astro']= (isset($new_form_data['otm_astro'][$key])) ? $new_form_data['otm_astro'][$key] : '';
				$order_trans_mesurement_data['otm_charlie']= (isset($new_form_data['otm_charlie'][$key])) ? $new_form_data['otm_charlie'][$key] : '';
				$order_trans_mesurement_data['otm_chinese']= (isset($new_form_data['otm_chinese'][$key])) ? $new_form_data['otm_chinese'][$key] : '';

				$order_trans_mesurement_data['otm_alag_collar_value']= (isset($new_form_data['otm_alag_collar_value'][$key])) ? $new_form_data['otm_alag_collar_value'][$key] : '';
				$order_trans_mesurement_data['otm_cutway_value']= (isset($new_form_data['otm_cutway_value'][$key])) ? $new_form_data['otm_cutway_value'][$key] : '';
				$order_trans_mesurement_data['otm_astro_value']= (isset($new_form_data['otm_astro_value'][$key])) ? $new_form_data['otm_astro_value'][$key] : '';
				$order_trans_mesurement_data['otm_charlie_value']= (isset($new_form_data['otm_charlie_value'][$key])) ? $new_form_data['otm_charlie_value'][$key] : '';
				$order_trans_mesurement_data['otm_chinese_value']= (isset($new_form_data['otm_chinese_value'][$key])) ? $new_form_data['otm_chinese_value'][$key] : '';

			}
			if($new_form_data['otm_app_id'][$key] == 1 || $new_form_data['otm_app_id'][$key] == 5)
			{
				$order_trans_mesurement_data['otm_f_b']	= (isset($new_form_data['otm_f_b'][$new_form_data['otm_mm_id'][$key]])) ? $new_form_data['otm_f_b'][$new_form_data['otm_mm_id'][$key]] : '';
				$order_trans_mesurement_data['otm_aagal_thi_low']	= (isset($new_form_data['otm_aagal_thi_low'][$key])) ? $new_form_data['otm_aagal_thi_low'][$key] : '';
			}

			$order_trans_mesurement_data['otm_notes'] 		= $new_form_data['otm_notes'][$new_form_data['otm_mm_id'][$key]];
			$order_trans_mesurement_data['otm_notes_maap'] = $new_form_data['otm_notes_maap'][$new_form_data['otm_mm_id'][$key]];

			$maap_data = $this->ordermdl->get_measurement_data_by_apparel($new_form_data['otm_mm_id'][$key]);
			$style_data = $this->ordermdl->get_measurement_data_by_apparel_style($new_form_data['otm_mm_id'][$key]);
			// echo "<pre>"; print_r($maap_data); 
			// echo "<pre>"; print_r($order_trans_mesurement_data); exit;
			if(!empty($maap_data)){
				foreach ($maap_data as $value1) 
				{
					// $col_name = strtolower(trim($value1['maap_name'], ' '));
					// $col_name = str_replace('-', '_', $col_name);
					// $col_name = str_replace(' ', '_', $col_name);
					$col_name = preg_replace("/[\s-.&\/\\<>#,+\"'\$~%.()?*:{}=]/", "_", strtolower(trim($value1['maap_name'])));
					// echo "<pre>"; print_r($col_name); 
					if(array_key_exists('otm_'.$col_name, $new_form_data))
					{
						if(array_key_exists($new_form_data['otm_mm_id'][$key], $new_form_data['otm_'.$col_name]))
						{
							$order_trans_mesurement_data['otm_'.$col_name] = empty($new_form_data['otm_'.$col_name][$new_form_data['otm_mm_id'][$key]]) ? '' : $new_form_data['otm_'.$col_name][$new_form_data['otm_mm_id'][$key]];
							// echo "<pre>"; print_r($col_name); 
							// echo "<pre>";print_r($order_trans_mesurement_data);
						}
					}						
				}
			}	
			// exit;
			if(!empty($style_data)){
				foreach ($style_data as $value2) 
				{
					$col_name1 = preg_replace("/[\s-.&\/\\<>#,+\"'\$~%.()?*:{}=]/", "_", strtolower(trim($value2['style_name'])));

					$order_trans_mesurement_data1 = $this->db_operations->get_record('order_trans_measurement',array('otm_id' => $value));  
					// echo "<pre>"; print_r($order_trans_mesurement_data1[0]); exit;
					if(!empty($order_trans_mesurement_data1))
					{ 
						// pre(array_key_exists('otm_'.$col_name1, $order_trans_mesurement_data1[0]));exit;
						if(array_key_exists('otm_'.$col_name1, $order_trans_mesurement_data1[0]))
	                    {
	                    	$check_update = array();
	                    	$check_update['otm_'.$col_name1] = "";
							// echo "<pre>"; print_r($check_update); 
		                    if($this->db_operations->data_update('order_trans_measurement', $check_update, 'otm_id', $value) < 1){
		                    	return ['status' => FALSE, 'data' => FALSE, 'msg' => 'Order Trans measurement not updated.'];
		                    }
	                    }
					}
					// echo "<pre>"; print_r($col_name1); 

					if(array_key_exists('otm_'.$col_name1, $new_form_data))
					{
						if(array_key_exists($new_form_data['otm_mm_id'][$key], $new_form_data['otm_'.$col_name1]))
						{
							$order_trans_mesurement_data['otm_'.$col_name1] = empty($new_form_data['otm_'.$col_name1][$new_form_data['otm_mm_id'][$key]]) ? '' : $new_form_data['otm_'.$col_name1][$new_form_data['otm_mm_id'][$key]];
							// echo "<pre>"; print_r($col_name); 
							// echo "<pre>";print_r($order_trans_mesurement_data);
						}
					}						
				}
			}		
			// echo "<pre>";print_r($order_trans_mesurement_data);exit;		
			if ($value == 0)
			{
				$order_trans_mesurement_data['otm_temprary_measurement']	= 1;// this is temprary entry when value is 1 and 0 for confirn measurement of order transaction

				$otm_id = $this->db_operations->data_insert('order_trans_measurement', $order_trans_mesurement_data);

				if($otm_id < 1){
					return ['status' => FALSE, 'data' => FALSE, 'msg' => 'Order Trans measurement not inserted.'];
				}
			}
			else
			{
				if($this->db_operations->data_update('order_trans_measurement',$order_trans_mesurement_data,'otm_id',$value) < 1){
					return ['status' => FALSE, 'data' => FALSE, 'msg' => 'Order Trans measurement not updated.'];
				}
				$otm_id = $value; 
			}	
			if(!empty($otm_ids)) $otm_ids .= ', ';
			$otm_ids .= $otm_id;
			
		}
		return ['status' => TRUE, 'data' => $otm_ids, 'msg' => ''];
	}

	public function get_gst_bill_no()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_fin_year_wise_max_id('order_master','om_gst_inv_no','om_fin_year',$_SESSION['fin_year']);
			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}


	public function check_duplicate_app_code($app_code)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$chart = trim($app_code);
			$record = $this->ordermdl->check_duplicate_app_code_record($chart,$_SESSION['fin_year']);

			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function cancel_gst_bill_no($bill_no)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_fin_year_wise_max_id('order_master','om_gst_inv_no','om_fin_year',$_SESSION['fin_year']);
			
			if (($record - $bill_no) > 1) 
			{
				echo 2;
			}
			else
			{
				echo 1;
			}
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function order_trans_delivery($ot_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$form_data = $this->input->post();

			// echo "<pre>";print_r($form_data);exit;

			$this->db->trans_begin();
			$flag = array();
			$flag['ot_delivered'] = 1;
			$result = $this->db_operations->data_update('order_trans', $flag, 'ot_id', $ot_id);

			if ($this->db->trans_status() === FALSE) {
			    $this->db->trans_rollback();
			    echo 0;
			} else {
			    $this->db->trans_commit();
			  	echo 1;
			}			
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function order_trans_delivery_reset($ot_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$form_data = $this->input->post();


			// echo "<pre>";print_r($form_data);exit;

			$this->db->trans_begin();
			$flag = array();
			$flag['ot_delivered'] = 0;
			$result = $this->db_operations->data_update('order_trans', $flag, 'ot_id', $ot_id);

			if ($this->db->trans_status() === FALSE) {
			    $this->db->trans_rollback();
			    echo 0;
			} else {
			    $this->db->trans_commit();
			  	echo 1;
			}			
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function order_update_approval($om_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$form_data = $this->input->post();

			$form_data['om_checkbox'] = isset($_POST['om_checkbox']) ? 1 : 0;

			// echo "<pre>";print_r($form_data);exit;
			$this->db->trans_begin();
			$result = $this->db_operations->data_update('order_master', $form_data, 'om_id', $om_id);
			isset($_POST['om_checkbox']) ? $this->db_operations->data_update('order_trans' , ['ot_delivered' => 1], 'ot_om_id', $om_id) : $this->db_operations->data_update('order_trans' , ['ot_delivered' => 0], 'ot_om_id', $om_id);
			

			if ($this->db->trans_status() === FALSE) {
			    $this->db->trans_rollback();
			    echo 0;
			} else {
			    $this->db->trans_commit();
			  	echo 1;
			}			
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}


	public function order_insert($om_id)
	{
		if (sessionExist()) 
		{			
			$form_data = $this->input->post();

			// echo "<pre>";print_r($form_data);exit();

			/*order master data array*/
			$order_data = array();
			
			$order_data['om_date'] 			= date('Y-m-d',strtotime($form_data['om_date']));
			$order_data['om_trial_date'] 	= date('Y-m-d',strtotime($form_data['om_trial_date']));
			$order_data['om_delivery_date'] = date('Y-m-d',strtotime($form_data['om_delivery_date']));
			$order_data['om_old_no'] 	    = $form_data['om_old_no'];
			$order_data['om_fabric_bill_no']= $form_data['om_fabric_bill_no'];
			$order_data['om_client_id'] 	= $form_data['om_client_id_hidden'];
			$order_data['om_client_id2'] 	= $form_data['om_client_id2'];
			$order_data['om_client_mobile'] = $form_data['om_client_mobile'];
			$order_data['om_gst_type'] 		= $form_data['om_gst_type'];
			// $order_data['om_mojdi_size'] 	= $form_data['om_mojdi_size'];
			$order_data['om_notes'] 		= $form_data['om_notes'];
			$order_data['om_courier'] 		= !empty($form_data['om_courier']) ? $form_data['om_courier'] : '';
			$order_data['om_courier_address'] = !empty($form_data['om_courier_address']) ? $form_data['om_courier_address'] : '';
			$order_data['om_gross_total'] 	= $form_data['om_gross_total'];
			$order_data['om_disc_amt'] 		= $form_data['om_disc_amt'];
			$order_data['om_final_total'] 	= $form_data['om_final_total'];
			$order_data['om_advance'] 		= $form_data['om_advance'];
			$order_data['om_roundoff'] 		= $form_data['om_roundoff'];
			$order_data['om_balance'] 		= $form_data['om_balance'];
			$order_data['om_total_qty'] 	= $form_data['om_total_qty'];
			$order_data['om_approve'] 		= $form_data['om_approve'];

			$order_data['om_fabric_amt'] 	= $form_data['om_fabric_amt'];
			$order_data['om_collected'] 	= $form_data['om_collected'];

			$order_data['om_payment_mode'] 	= $form_data['om_payment_mode'];

			if (isset($form_data['om_bank_name'])) 
			{
				$order_data['om_bank_name'] 	= $form_data['om_bank_name'];
			}

			if (isset($form_data['om_cheq_dd_no'])) 
			{
				$order_data['om_cheq_dd_no'] 	= $form_data['om_cheq_dd_no'];
			}

			if (isset($form_data['om_cheq_dd_date'])) 
			{
				$order_data['om_cheq_dd_date'] 	= date('Y-m-d',strtotime($form_data['om_cheq_dd_date']));
			}

			if (isset($form_data['om_neft_amt'])) 
			{
				$order_data['om_neft_amt'] 	= $form_data['om_neft_amt'];
			}

			if (isset($form_data['om_neft_date'])) 
			{
				$order_data['om_neft_date'] 	= date('Y-m-d',strtotime($form_data['om_neft_date']));
			}

			if (isset($form_data['om_card_type'])) 
			{
				$order_data['om_card_type'] 	= $form_data['om_card_type'];
			}

			if (isset($form_data['om_card_no'])) 
			{
				$order_data['om_card_no'] 	= $form_data['om_card_no'];
			}

			if (isset($form_data['om_expiry_date'])) 
			{
				$order_data['om_expiry_date'] 	= date('Y-m-d',strtotime($form_data['om_expiry_date']));
			}

			// echo "<pre>";print_r($sale_data);exit();

			if ($om_id == 0) 
			{
				$this->db->trans_begin();
				/*check duplicate purchase entry no*/
				// $cnt = $this->ordermdl->check_duplicate_sale_entry($form_data['sm_inv_no'],$_SESSION['fin_year']);
				$max_id = $this->ordermdl->get_fin_year_wise_max_id('order_master','om_no','om_fin_year',$_SESSION['fin_year']);

				if($form_data['om_no'] == ''){
					$om_no = $max_id;
				}else{
					$om_no = $form_data['om_no'];
				}

				// $order_data['om_no'] 			= $max_id;
				$order_data['om_no'] 			= $om_no;
				$order_data['om_fin_year'] 		= $_SESSION['fin_year'];	
				$order_data['om_user_id'] 		= $_SESSION['user_id'];				
				$order_data['om_cdate'] 		= date('Y-m-d');				
				$order_data['om_modify_uid'] 	= $_SESSION['user_id'];				
				$order_data['om_modify_cdate'] 	= date('Y-m-d H:i:s');

				/*insert data to order_master table*/
				$result_id = $this->db_operations->data_insert('order_master', $order_data);
				
				if (!empty($result_id)) {

					$this->db_operations->data_update('client_master',array('client_mobile1'=>$order_data['om_client_mobile']),'client_id', $order_data['om_client_id']);

					/*insert data to order_trans table*/
					$ot_result 	= $this->insert_update_order_trans($form_data, $result_id);

					/*sms functionality is off for testing module*/
					$tot_bal = $form_data['om_balance'];
					$tot_amt = $form_data['om_final_total'];
					
					$mob = $form_data['om_client_mobile'];
					$ml_bill_no = $order_data['om_no'];

					if(($_SESSION['user_role_id'] == 1 || $_SESSION['user_role_id'] == 2 || $_SESSION['user_role_id'] == 4)):

						$tot_adv = $form_data['om_advance'];

						if($tot_adv != 0):
							$msg = "Thank you for your Payment . We acknowledge your advance payment of Rs. $tot_adv against Order no $ml_bill_no. Your balance amt is Rs.$tot_bal. We appreciate your time, Thank you.";
						// echo $msg;exit;
						else:
							$msg = "Thank you for your Purchase. Your Order no is $ml_bill_no Bill Amount is Rs $tot_amt. We truly appreciate your visit and look forward to serve you.";
						endif;
						$sms_result = $this->send_sms_for_order($mob,$msg);
					elseif($_SESSION['user_role_id'] == 3):
						$msg = "Thank you for your Purchase. Your Order no is $ml_bill_no Bill Amount is Rs $tot_amt. We truly appreciate your visit and look forward to serve you.";
						$sms_result = $this->send_sms_for_order($mob,$msg);
					endif;
				}

				if ($this->db->trans_status() === FALSE) {
				    $this->db->trans_rollback();
				    echo 0;
				} else {
				    $this->db->trans_commit();

				    $resp = array();
					$om_id_print = encrypt_decrypt("encrypt", $result_id, SECRET_KEY);

					$resp['flag'] = 1;
					$resp['om_id_print'] = ''.$om_id_print.'';
					$resp['om_id'] = $result_id;
					$resp['mobileno'] = $mob;
					$resp['bill_no'] = $ml_bill_no;

					echo json_encode($resp);
				}			
			}
			else
			{
				$this->db->trans_begin();
				/*update code*/
				$edit_cnt = $this->ordermdl->check_edit_duplicate_order_entry($form_data['om_no'],$_SESSION['fin_year'],$om_id);

				if ($edit_cnt != 0) 
				{
					echo 2;
				}
				else
				{
					$order_data['om_no'] 			= $form_data['om_no'];
					$order_data['om_fin_year'] 		= $_SESSION['fin_year'];	
					$order_data['om_modify_uid'] 	= $_SESSION['user_id'];				
					$order_data['om_modify_cdate'] 	= date('Y-m-d H:i:s');

					// echo "<pre>";print_r($order_data);exit();

					/*update data to order_master table*/
					$result = $this->db_operations->data_update('order_master', $order_data, 'om_id', $om_id);
					$om_id_print = encrypt_decrypt("encrypt", $om_id, SECRET_KEY);
					$resp['om_id'] = $om_id;
					$mob = $form_data['om_client_mobile'];
					$ml_bill_no = $order_data['om_no'];

					if (!empty($result)) 
					{
						$this->db_operations->data_update('client_master',array('client_mobile1'=>$order_data['om_client_mobile']),'client_id', $order_data['om_client_id']);
						/*update data to order_trans table*/
						$ot_result 	= $this->insert_update_order_trans($form_data, $om_id);
					}

					if ($this->db->trans_status() === FALSE) {
					    $this->db->trans_rollback();
					    echo 0;
					} else {
					    $this->db->trans_commit();
						$resp = array();
						$resp['flag'] = 1;
						$resp['om_id_print'] = ''.$om_id_print.'';
						$resp['om_id'] = $om_id;
						$resp['mobileno'] = $mob;
						$resp['bill_no'] = $ml_bill_no;
						echo json_encode($resp);
					}	
				} 
			}
		} 
		else 
		{
			redirect('loginctrl/logout');
		}
	}


	public function insert_update_order_trans($form_data,$om_id)
	{	
		// 0 = not avialable
		// 1 = avialable
		$order_trans_data = $this->db_operations->get_record('order_trans',array('ot_om_id' =>$om_id)); // get all db record first and all form data and match who is missing and those data delete by system  

		foreach ($order_trans_data as $key => $value) 
		{
			// check data from database exists in form, if not exists then delete data from database
			if (!in_array($value['ot_id'], $form_data['ot_id'])) 
			{
				// if($value['ot_app_type'] == 'Fabric')
			    // {
				// 	if($value['ot_item_code'] > 0)
				// 	{
				// 		// get branch barcode data from database
				// 		$isb_data_db = $this->db_operations->get_record('inward_stock_barcode', ['isb_id' => $value['ot_item_code']]);

				// 		if(empty($isb_data_db))
				// 		{
				// 			return -1;
				// 		}
				// 		else
				// 		{
				// 			$db_qty 	= $isb_data_db[0]['isb_sales_out_qty'];
				// 			$form_qty 	= $value['ot_final_out_qty'];

				// 			$total_qty = $db_qty - $form_qty;

				// 			$result = $this->db_operations->data_update('inward_stock_barcode' , ['isb_sales_out_qty' => $total_qty], 'isb_id', $value['ot_item_code']);

				// 			if($result < 0)
				// 			{
				// 				return -1;
				// 			}
				// 		}
				// 	}	
				// 	$del_res = $this->db_operations->delete_record('order_trans',array('ot_id' =>$value['ot_id']));
						
				// 	if(empty($del_res))
				// 	{
				// 		return -1;
				// 	}	
				// }

				// if($value['ot_app_type'] == 'Package' && $value['ot_qty_mtr'] != 0)
			    // {
				// 	if($value['ot_item_code'] > 0)
				// 	{
				// 		// get branch barcode data from database
				// 		$isb_data_db = $this->db_operations->get_record('inward_stock_barcode', ['isb_id' => $value['ot_item_code']]);

				// 		if(empty($isb_data_db))
				// 		{
				// 			return -1;
				// 		}
				// 		else
				// 		{
				// 			$db_qty 	= $isb_data_db[0]['isb_sales_out_qty'];
				// 			$form_qty 	= $value['ot_final_out_qty'];

				// 			$total_qty = $db_qty - $form_qty;

				// 			$result = $this->db_operations->data_update('inward_stock_barcode' , ['isb_sales_out_qty' => $total_qty], 'isb_id', $value['ot_item_code']);

				// 			if($result < 0)
				// 			{
				// 				return -1;
				// 			}
				// 		}
				// 	}	
				// 	$del_res = $this->db_operations->delete_record('order_trans',array('ot_id' =>$value['ot_id']));
						
				// 	if(empty($del_res))
				// 	{
				// 		return -1;
				// 	}	
				// }
			}

			if (!in_array($value['ot_logic'], $form_data['ot_logic'])) 
			{	
				/*delete transactions*/
				$del_res = $this->db_operations->delete_record('order_trans',array('ot_logic' =>$value['ot_logic']));
			}
		}

		$total_gross_amt 	= 0;
		$total_disc_amt 	= 0;
		$total_final_amt 	= 0;
		$total_final_qty 	= 0;

		// echo "<pre>";print_r($form_data);exit;
		foreach ($form_data['ot_id'] as $key => $value) 
		{
			/*order transaction data*/
			$order_trans = array();
			
			if($value == 0) 
			{
				if($form_data['ot_app_type'][$key] == 'Stitching' )
				{
					for($i = 0;$i < $form_data['ot_qty'][$key];$i++)
					{
						$order_trans['ot_om_id'] 		= $om_id;
						$order_trans['ot_otm_id'] 		= isset($form_data['ot_otm_id'][$key])?$form_data['ot_otm_id'][$key]:0;
						$order_trans['ot_app_type'] 	= $form_data['ot_app_type'][$key];
						$order_trans['ot_item_id'] 		= isset($form_data['ot_item_id'][$key]) ? $form_data['ot_item_id'][$key] : '';
						$order_trans['ot_item_code'] 	= isset($form_data['ot_item_code'][$key]) ? $form_data['ot_item_code'][$key] : '' ;
						
						$order_trans['ot_desc'] 		= $form_data['ot_desc'][$key];
						$order_trans['ot_qty'] 			= 1;
						// $order_trans['ot_final_out_qty']= $form_data['ot_final_out_qty'][$key];
						$order_trans['ot_rate'] 		= $form_data['ot_rate'][$key];
						$order_trans['ot_sub_amt'] 		= $form_data['ot_sub_amt'][$key];
						$order_trans['ot_disc_per'] 	= $form_data['ot_disc_per'][$key];
						$order_trans['ot_disc_amt'] 	= $form_data['ot_disc_amt'][$key];
						$order_trans['ot_final_total'] 	= $form_data['ot_final_total'][$key];
						$order_trans['ot_trial'] 		= $form_data['ot_trial'][$key];
						$order_trans['ot_attachment_preview'] 	= isset($form_data['ot_attachment_preview'][$key])?$form_data['ot_attachment_preview'][$key]:'';

						$log = $form_data['ot_logic'][$key];
						$code = $om_id.'_'.$log;

						$order_trans['ot_logic'] 		= $code;

						$apparel_data = $this->ordermdl->get_apparel_apparel_trans_data_order($form_data['ot_item_id'][$key]);

						if(!empty($apparel_data))
						{
							$order_trans['ot_multiple_barcode'] = 'YES';

							$order_trans_result = $this->db_operations->data_insert('order_trans', $order_trans);
							$apparel_data = $this->add_apparel_transaction($order_trans,$order_trans_result,$om_id,$form_data['om_client_id_hidden']);
						}
						else
						{

							$order_trans['ot_multiple_barcode'] = 'NO';
							$year			= date('y');
							$month          = date('m');

							$order_trans['ot_chart_no'] 		= $this->ordermdl->generate_barcode_for_order();
							$order_trans['ot_barcode'] 			= $year.''.$month.''.$order_trans['ot_chart_no'];
					
							$order_trans['ot_barcode_year'] 	= $year;
							$order_trans['ot_barcode_month'] 	= $month;

							$log = $form_data['ot_logic'][$key];
							$code = $om_id.'_'.$log;

							$order_trans['ot_logic'] 		= $code;


							$order_trans_result = $this->db_operations->data_insert('order_trans', $order_trans);
							if($order_trans_result<1)
							{
								return ['status' => FALSE, 'data' => FALSE, 'msg' => 'order trans  not inserted.'];
							}
							if(!empty($order_trans['ot_otm_id']))
							{
								if($this->db_operations->data_update('order_trans_measurement',array('otm_om_id'=>$order_trans['ot_om_id'],'otm_ot_id'=>$order_trans_result,'otm_temprary_measurement'=>0),'otm_id',$order_trans['ot_otm_id']) < 1){
									return ['status' => FALSE, 'data' => FALSE, 'msg' => 'order trans measurement not updated in Stitching.'];
								}
							}
						}
						// echo "<pre>";print_r($order_trans);exit;
					}
				}
				else if($form_data['ot_app_type'][$key] == 'Fabric')
				{
					$order_trans['ot_om_id'] 		= $om_id;
					$order_trans['ot_app_type'] 	= $form_data['ot_app_type'][$key];
					$order_trans['ot_item_id'] 		= isset($form_data['ot_item_id'][$key]) ? $form_data['ot_item_id'][$key] : '';
					$order_trans['ot_makki_id'] 		= isset($form_data['ot_makki_id'][$key]) ? $form_data['ot_makki_id'][$key] : '';
					$order_trans['ot_item_code'] 	= isset($form_data['ot_item_code'][$key]) ? $form_data['ot_item_code'][$key] : '' ;
					// $order_trans['ot_fabric'] 		= $form_data['ot_fabric'][$key];
					// $order_trans['ot_embroidery'] 	= $form_data['ot_embroidery'][$key];
					// $order_trans['ot_makki'] 		= $form_data['ot_makki'][$key];
					// $order_trans['ot_p'] 			= $form_data['ot_p'][$key];
					// $order_trans['ot_pi'] 			= $form_data['ot_pi'][$key];
					$order_trans['ot_desc'] 		= $form_data['ot_desc'][$key];
					$order_trans['ot_qty'] 			= $form_data['ot_qty'][$key];
					// $order_trans['ot_final_out_qty']= $form_data['ot_final_out_qty'][$key];
					$order_trans['ot_rate'] 		= $form_data['ot_rate'][$key];
					$order_trans['ot_sub_amt'] 		= $form_data['ot_sub_amt'][$key];
					$order_trans['ot_disc_per'] 	= $form_data['ot_disc_per'][$key];
					$order_trans['ot_disc_amt'] 	= $form_data['ot_disc_amt'][$key];
					$order_trans['ot_final_total'] 	= $form_data['ot_final_total'][$key];
					$order_trans['ot_trial'] 		= $form_data['ot_trial'][$key];
					$order_trans['ot_attachment_preview'] 	= isset($form_data['ot_attachment_preview'][$key])?$form_data['ot_attachment_preview'][$key]:'';

			
					$year			= date('y');
					$month          = date('m');

					$log = $form_data['ot_logic'][$key];
					$code = $om_id.'_'.$log;

					$order_trans['ot_logic'] 		= $code;

					// echo "<pre>";print_r($order_trans);exit;


					$order_trans_result = $this->db_operations->data_insert('order_trans', $order_trans);

					if($order_trans_result < 1)
					{
						return -1;
					}
					

				}
				
			} 
			else 
			{
				// echo "<pre>";print_r($form_data);exit;
				/*order transaction update process*/
				// for($i = 0;$i < $form_data['ot_qty'][$key];$i++)
				// {
				if($form_data['ot_app_type'][$key] == 'Stitching' )
				{
					// $order_trans['ot_qty'] 			= 1;
					// $order_trans['ot_fabric'] 		= $form_data['ot_fabric'][$key];
					// $order_trans['ot_embroidery'] 	= $form_data['ot_embroidery'][$key];
					// $order_trans['ot_makki'] 		= $form_data['ot_makki'][$key];
					// $order_trans['ot_p'] 			= $form_data['ot_p'][$key];
					// $order_trans['ot_pi'] 			= $form_data['ot_pi'][$key];
					
					$order_trans['ot_otm_id'] 		= isset($form_data['ot_otm_id'][$key])?$form_data['ot_otm_id'][$key]:0;

					$order_trans['ot_item_id'] 		= isset($form_data['ot_item_id'][$key]) ? $form_data['ot_item_id'][$key] : '';

					$order_trans['ot_final_out_qty']= $form_data['ot_final_out_qty'][$key];
					$order_trans['ot_desc'] 		= $form_data['ot_desc'][$key];
					$order_trans['ot_rate'] 		= $form_data['ot_rate'][$key];
					$order_trans['ot_sub_amt'] 		= $form_data['ot_sub_amt'][$key];
					$order_trans['ot_disc_per'] 	= $form_data['ot_disc_per'][$key];
					$order_trans['ot_disc_amt'] 	= $form_data['ot_disc_amt'][$key];
					$order_trans['ot_final_total'] 	= $form_data['ot_final_total'][$key];
					$order_trans['ot_trial'] 		= $form_data['ot_trial'][$key];
					$order_trans['ot_attachment_preview'] 	= isset($form_data['ot_attachment_preview'][$key])?$form_data['ot_attachment_preview'][$key]:'';

					$apparel_data = $this->ordermdl->get_apparel_apparel_trans_data_order($form_data['ot_item_id'][$key]);
					 // echo "<pre>";print_r($apparel_data);exit;

					if(!empty($apparel_data))
					{
						$ot_multiple_barcode = 'YES';
						$order_trans_result = $this->db_operations->data_update('order_trans',$order_trans,'ot_id',$form_data['ot_id'][$key]);

						$apparel_data = $this->update_apparel_transaction($ot_multiple_barcode,$order_trans,$value,$om_id,$form_data['om_client_id_hidden']);
					}
					else
					{
						$order_trans_result = $this->db_operations->data_update('order_trans',$order_trans,'ot_logic',$form_data['ot_logic'][$key]);

						if(!empty($order_trans['ot_otm_id']))
						{
							if($this->db_operations->data_update('order_trans_measurement',array('otm_om_id'=>$om_id,'otm_ot_id'=>$value,'otm_temprary_measurement'=>0),'otm_id',$order_trans['ot_otm_id']) < 1){
								return ['status' => FALSE, 'data' => FALSE, 'msg' => 'order trans measurement not updated in Stitching.'];
							}
						}
					}

					
				}
				else if($form_data['ot_app_type'][$key] == 'Fabric')
				{
					$order_trans['ot_qty'] 			= 1;
					// $order_trans['ot_fabric'] 		= $form_data['ot_fabric'][$key];
					// $order_trans['ot_embroidery'] 	= $form_data['ot_embroidery'][$key];
					// $order_trans['ot_makki'] 		= $form_data['ot_makki'][$key];
					// $order_trans['ot_p'] 			= $form_data['ot_p'][$key];
					// $order_trans['ot_pi'] 			= $form_data['ot_pi'][$key];
					$order_trans['ot_desc'] 		= $form_data['ot_desc'][$key];
					$order_trans['ot_rate'] 		= $form_data['ot_rate'][$key];
					$order_trans['ot_final_out_qty']= $form_data['ot_final_out_qty'][$key];
					$order_trans['ot_sub_amt'] 		= $form_data['ot_sub_amt'][$key];
					$order_trans['ot_disc_per'] 	= $form_data['ot_disc_per'][$key];
					$order_trans['ot_disc_amt'] 	= $form_data['ot_disc_amt'][$key];
					$order_trans['ot_final_total'] 	= $form_data['ot_final_total'][$key];
					$order_trans['ot_trial'] 		= $form_data['ot_trial'][$key];
					$order_trans['ot_item_code'] 	= isset($form_data['ot_item_code'][$key]) ? $form_data['ot_item_code'][$key] : '' ;
					$order_trans['ot_attachment_preview'] 	= isset($form_data['ot_attachment_preview'][$key])?$form_data['ot_attachment_preview'][$key]:'';


					$order_trans_result = $this->db_operations->data_update('order_trans',$order_trans,'ot_logic',$form_data['ot_logic'][$key]);

					if($order_trans_result < 1)
					{
						return -1;
					}
				
				}
				
			}

			$total_gross_amt 	+= $form_data['ot_sub_amt'][$key];
			$total_disc_amt 	+= $form_data['ot_disc_amt'][$key];
			$total_final_amt 	+= $form_data['ot_final_total'][$key];
			$total_final_qty 	+= $form_data['ot_qty'][$key];
		}

		$order_array = array();
		$order_array['om_gross_total'] 		= $total_gross_amt;
		$order_array['om_disc_amt'] 		= $total_disc_amt;
		$order_array['om_final_total'] 		= $total_final_amt;
		$order_array['om_total_qty'] 		= $total_final_qty;
		$order_array['om_balance'] 			= $total_final_amt - (float)$form_data['om_roundoff'] - (float)$form_data['om_advance'];
		
		$this->db_operations->data_update('order_master', $order_array, 'om_id', $om_id);
	}

	public function add_apparel_transaction($temp,$ot_id,$om_id,$client_id){
        $post_data  = $this->input->post();
        // echo"<pre>";print_r($ot_id);exit;

        $id = $om_id;
        if($temp['ot_multiple_barcode'] == 'YES')
        {
            $apparel_data = $this->ordermdl->get_apparel_apparel_data($ot_id, $temp['ot_item_id']);
            // echo"<pre>";print_r($apparel_data);exit;
            if(empty($apparel_data)) return [];
            $resp = [];
            foreach ($apparel_data as $key => $value) {
                $trans_data    = [];
                $trans_data['ot_otm_id']    = 0;
                if(!empty($temp['ot_otm_id']))
                {
                	// echo"<pre>";print_r($temp['ot_otm_id']);exit;
                	$otm_id = explode(",",$temp['ot_otm_id']);
	                foreach ($otm_id as $key1 => $value1) {
	                	$otm_id_1 = $this->db_operations->get_record('order_trans_measurement',['otm_id' => $value1,'otm_app_id' => $value['ot_item_id'],'otm_client_id' => $client_id]);
	                	if(!empty($otm_id_1))
	                	{
	                		$trans_data['ot_otm_id']    = $value1;
	                	}
	                }
                }
                // echo"<pre>";print_r(4556);exit;
                
                $trans_data['ot_ot_id']         = $ot_id;
                $trans_data['ot_om_id'] 		= $om_id;
                $trans_data['ot_app_type']    = $temp['ot_app_type'];
                $trans_data['ot_item_id']    = $value['ot_item_id'];
                $trans_data['ot_qty']           = $temp['ot_qty'];
                $trans_data['ot_desc']   = $temp['ot_desc'];

                $trans_data['ot_trial'] 		= $temp['ot_trial'];
				$trans_data['ot_attachment_preview'] 	= isset($temp['ot_attachment_preview'])?$temp['ot_attachment_preview']:'';

				$year			= date('y');
				$month          = date('m');

				$trans_data['ot_chart_no'] 		= $this->ordermdl->generate_barcode_for_order();
				$trans_data['ot_barcode'] 			= $year.''.$month.''.$trans_data['ot_chart_no'];
		
				$trans_data['ot_barcode_year'] 	= $year;
				$trans_data['ot_barcode_month'] 	= $month;

				$log = $temp['ot_logic'];
				$code = $log;

				$trans_data['ot_logic'] 		= $code;
				$trans_data['ot_multiple_barcode'] = 'NO';


    
                // if($post_data['ot_id'][0] == 0){
                    $trans_data['ot_id'] = $this->db_operations->data_insert('order_trans', $trans_data);
                    // if($trans_data['ot_id'] < 1) return ['msg' => '2. Order Transaction not added.'];
                    // $trans_data['isExist'] = false;
                    // $trans_data['ot_om_id'] = 0;
                // }else{
                //     $trans_data['ot_om_id'] = $id;
                //     $trans_data['ot_id']    = $value['ot_id'];
                // }
                if(!empty($trans_data['ot_otm_id']))
            	{
            		if($this->db_operations->data_update('order_trans_measurement',array('otm_om_id'=>$om_id,'otm_ot_id'=>$trans_data['ot_id'],'otm_temprary_measurement'=>0),'otm_id',$trans_data['ot_otm_id']) < 1){
						return ['status' => FALSE, 'data' => FALSE, 'msg' => 'order trans measurement not updated in Stitching.'];
					}
            	}

                $trans_data['apparel_name'] = $value['app_name'];
                array_push($resp, $trans_data);
            }
            return $resp;
        }
	}

	public function update_apparel_transaction($ot_multiple_barcode,$temp,$ot_id,$om_id,$client_id){
        $post_data  = $this->input->post();
        // echo"<pre>";print_r($ot_id);exit;

        $id = $om_id;
        if($ot_multiple_barcode == 'YES')
        {
            $apparel_data = $this->ordermdl->get_apparel_apparel_data($ot_id, $temp['ot_item_id']);
            // echo"<pre>";print_r($apparel_data);exit;
            if(empty($apparel_data)) return [];
            $resp = [];
            foreach ($apparel_data as $key => $value) {
                $trans_data    = [];
                $trans_data['ot_otm_id']    = 0;
                if(!empty($temp['ot_otm_id']))
                {
                	// echo"<pre>";print_r($temp['ot_otm_id']);exit;
                	$otm_id = explode(",",$temp['ot_otm_id']);
	                foreach ($otm_id as $key1 => $value1) {
	                	$otm_id_1 = $this->db_operations->get_record('order_trans_measurement',['otm_id' => $value1,'otm_app_id' => $value['ot_item_id'],'otm_client_id' => $client_id]);
	                	if(!empty($otm_id_1))
	                	{
	                		$trans_data['ot_otm_id']    = $value1;
	                	}
	                }
                }
                // echo"<pre>";print_r(4556);exit;
                
                    // echo "<pre>";print_r($trans_data);exit;
                if(!empty($trans_data['ot_otm_id']))
            	{
            		if($this->db_operations->data_update('order_trans_measurement',array('otm_om_id'=>$om_id,'otm_ot_id'=>$value['ot_id'],'otm_temprary_measurement'=>0),'otm_app_id',$value['ot_item_id'],'otm_id',$trans_data['ot_otm_id']) < 1){
						return ['status' => FALSE, 'data' => FALSE, 'msg' => 'order trans measurement not updated in Stitching.'];
					}
            	}

                $trans_data['apparel_name'] = $value['app_name'];
                array_push($resp, $trans_data);
            }
            return $resp;
        }
	}


	public function order_delete($om_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			/*db transaction starts*/
			$this->db->trans_begin();
			/*delete order records*/
			
			$data = $this->ordermdl->get_order_trans_record($om_id);
			
			$issue_flag = 0;

			foreach ($data as $key => $value) 
			{
				if ($value['ot_km_id'] != 0) 
				{
					$issue_flag = 1;
				}
			}

			if ($issue_flag == 0) 
			{
				foreach ($data as $key => $value) 
				{
					if($value['ot_app_type'] == 'Fabric')
					{
						if($value['ot_id'] > 0)
						{
							$bbim_data_db = $this->db_operations->get_record('inward_stock_barcode', ['isb_id' => $value['ot_item_code']]);

							$db_qty 	= $bbim_data_db[0]['isb_sales_out_qty'];
							$form_qty 	= $value['ot_qty'];

							$total_qty 	= $db_qty - $form_qty;

							$fb_result 	= $this->db_operations->data_update('inward_stock_barcode' , ['isb_sales_out_qty' => $total_qty], 'isb_id', $value['ot_item_code']);

							if($fb_result < 0)
							{
								$fb_flag = 1;
							}
						}
					}
				}

				$this->db_operations->delete_record('order_master', array('om_id' => $om_id));
				$this->db_operations->delete_record('order_trans', array('ot_om_id' => $om_id));
				
				if ($this->db->trans_status() === FALSE) {
				    $this->db->trans_rollback();
				    echo 0;
				} else {
				    $this->db->trans_commit();
					echo 1;
				}	

				
			}
			else
			{
				echo 2;
			}


			/*delete order voucher */
		} 
		else 
		{
			redirect('loginctrl/logout');
		}
	}


	/*Fabric Cutting Master */

/******************************** WHATSAPP *****************************/
    // public function whatsapp_msg($id){
    //     $record = $this->ordermdl->get_single_order_data_for_print($id);
    //     // echo"<pre>";print_r($record);exit;
    //     $data = $record['order_data'][0];
    //     if(!empty($record)){
    //         $this->load->view('pdfs/order_bill_download',$record);
    //         $mobile = $record['order_data'][0]['client_mobile1'];

    //         $msg     = 'Hello '.$record['order_data'][0]['om_client_id2'] . "\r\n";
    //         $msg    .= 'Please find attached your invoice for Aristo & sons' . "\r\n";
    //         $msg    .= 'Amount ' .$record['order_data'][0]['om_final_total'] . "\r\n";
           
    //         $msg    .= 'Thank you for choosing Aristo and sons';
           

    //         $path   = base_url("public/uploads/order/"."$id.pdf");
    //         $apikey   = 'sendFileWithCaption';
    //         if(!empty($mobile)){
    //             send_whatsapp($mobile, $msg, $path,$apikey);
    //         }
    //     }
    //     // return['status' => TRUE, 'data' => $data, 'msg' => 'Record fetched successfully.'];
    //     return ['status' => TRUE, 'data' => [], 'msg' => ''];
    // }
    
   /******************************** WHATSAPP *****************************/
    public function whatsapp_msg($id){
        $record = $this->ordermdl->get_single_order_data_for_print($id);
        // echo"<pre>";print_r($record);exit;
        $data = $record['order_data'][0];
        if(!empty($record)){
            $this->load->view('pdfs/order_bill_download',$record);
            $mobile = $record['order_data'][0]['client_mobile1'];

            $msg     = 'Hello '.$record['order_data'][0]['om_client_id2'] . "\r\n";
            $msg    .= 'Please find your attached  order for Rs.' .round($record['order_data'][0]['om_final_total']). '/-';
            $msg    .= 'Thank you for choosing. ARISTO.';
           

            $path   = base_url("public/uploads/order/"."$id.pdf");
            $apikey   = 'sendFileWithCaption';

            if(!empty($mobile)){
                send_whatsapp($mobile, $msg, $path,$apikey);
                // send_whatsapp($mobile, $msg);
            }
        }
        // return['status' => TRUE, 'data' => $data, 'msg' => 'Record fetched successfully.'];
        return ['status' => TRUE, 'data' => [], 'msg' => ''];
    }
    /******************************** WHATSAPP *****************************/

	public function client_insert($id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			
			$form_data = $this->input->post();

			// echo "<pre>";print_r($form_data);exit();
			/*client data*/
			

			$client_data = array();
			$client_data['client_accno'] 	= $this->ordermdl->get_max_id('client_master','client_accno');
			$client_data['client_name'] 	= trim($form_data['client_name']);
			$client_data['client_dob'] 		= date('Y-m-d',strtotime($form_data['client_dob']));
			$client_data['client_mobile1']	= trim($form_data['client_mobile1']);
			$client_data['client_mobile1_check']	= !empty($form_data['client_mobile1_check']) ? $form_data['client_mobile1_check'] : 0;
			$client_data['client_mobile2']	= !empty($form_data['client_mobile2']) ? $form_data['client_mobile2'] : '';
			$client_data['client_mobile2_check']	= !empty($form_data['client_mobile2_check']) ? $form_data['client_mobile2_check'] : 0;
			$client_data['client_reference_name']	= !empty($form_data['client_reference_name']) ? $form_data['client_reference_name'] : '';
			$client_data['client_country'] 	= !empty($form_data['client_country']) ? $form_data['client_country'] : '';
			$client_data['client_location'] = !empty($form_data['client_location']) ? $form_data['client_location'] : '';
			$client_data['client_location'] = !empty($form_data['client_location']) ? $form_data['client_location'] : '';
			$client_data['client_gst_type'] = $form_data['client_gst_type'];
			$client_data['client_status'] 	= 1;
			$client_data['client_type'] 	= $form_data['client_type'];

			// echo "<pre>";print_r($client_data);exit();

			if($id == 0) 
			{
				$this->db->trans_begin();

				$name_cnt 	= $this->ordermdl->check_duplicate_client_name($form_data['client_name']);
				$mob_cnt 	= $this->ordermdl->check_duplicate_client_mobile($form_data['client_mobile1']);

				if ($name_cnt != 0 && $mob_cnt != 0) 
				{
					echo 2;
				}
				// elseif($mob_cnt != 0)
				// {
				// 	echo 3;
				// } 
				else 
				{
					$client_data['client_userid'] 		 = $_SESSION['user_id'];
					$client_data['client_cdate'] 		 = date('Y-m-d');
					$client_data['client_modify_userid'] = $_SESSION['user_id'];
					
					// echo "<pre>";print_r($client_data);exit();

					$client_insertid = $this->db_operations->data_insert('client_master', $client_data);

					$resp = array();

					if ($this->db->trans_status() === FALSE) 
					{
					    $this->db->trans_rollback();
					    echo 0;
					} 
					else 
					{
					    $this->db->trans_commit();

					    $resp['flag'] 	= 1;
					    $resp['id'] 	= $client_insertid;
					    $resp['mob_no'] = $form_data['client_mobile1'];
					    $resp['name'] 	= $form_data['client_name'];

					    echo json_encode($resp);
					}			
				}
			}
		}
		else 
		{
			redirect('loginctrl/logout');		
		}
	}

	public function get_order_trans_data($ot_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$data = $this->ordermdl->get_order_trans_data($ot_id);
			// echo "<pre>";print_r($data);exit();

			echo json_encode($data);
		} 
		else 
		{
			redirect('loginctrl/logout');
		}
	}

	public function get_completed_order_data($om_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_done_order_trans_data($om_id);
			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function update_delivery_status(){
        $post_data  = $this->input->post();

        // print_r($post_data); exit;
        if(!empty($post_data)){
            foreach ($post_data['ot_id'] as $key => $value){

                $order_trans_data['ot_delivered'] 	= 1;

                if($this->db_operations->data_update('order_trans', $order_trans_data, 'ot_id', $value) < 1){
                    echo json_encode(['status' => FALSE,'msg' => 'Process not updated.']);
                }
            }
            echo json_encode(['status' => TRUE, 'data' => [], 'msg' => 'Delivered successfully.']);
        }
        else{
            echo json_encode(['status' => FALSE,'msg' => 'Cannot Deliver']);
        }
	}


	public function get_fabric_barcode()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{	
			$record = $this->db_operations->get_record_order_by("inward_stock_barcode",array('isb_id'=>1),"isb_item_code","ASC");
			// echo "<pre>";print_r($record);exit;
			echo json_encode($record);
		}
		else{
			redirect('loginctrl/logout');
		}
	}

	public function get_stitching_apparel()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{	
			$record = $this->ordermdl->get_stitching_apparel_data();
			echo json_encode($record);
		}
		else
			redirect('loginctrl/logout');
	}

	public function get_package_apparel()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{	
			$record['fabric'] = $this->db_operations->get_record_order_by("inward_stock_barcode",array('isb_id'=>1),"isb_item_code","ASC");

			$record['stitching'] = $this->ordermdl->get_package_apparel_data();

			// echo "<pre>";print_r($record);exit;
			echo json_encode($record);
		}
		else
			redirect('loginctrl/logout');
	}

	public function get_single_fabric_barcode_on_add($id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_fabric_barcode_with_name($id);
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}
	}

	public function get_single_fabric_barcode_and_apparel_on_add($id,$app_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record['fabric'] = $this->ordermdl->get_fabric_barcode_with_name($id);
			$record['stitching'] = $this->db_operations->get_record("apparel_master", array("app_id" => $app_id));
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}
	}

	public function get_single_stitching_apparel($app_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->db_operations->get_record("apparel_master", array("app_id" => $app_id));

			// $record['makki_name_data'] = $this->ordermdl->get_ot_makki_with_name($ot_makki_id);
			// echo "<pre>"; print_r($record);die();
			echo json_encode($record);
		}
		else
			redirect('loginctrl/logout');
	}

	public function get_select2_fabric_barcode_data()
	{
		$json = [];
		if (!empty($_GET['isb_item_code'])) 
		{
			$data = $this->ordermdl->get_fabric_barcode_details_select2($_GET['isb_item_code']);
			foreach ($data as $key => $value) 
			{
				$json[] = ['id'=>$value['isb_id'], 'text'=>$value['isb_item_code']];
			}
		}
		echo json_encode($json);
	}

	public function get_single_fabric_barcode($id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_fabric_barcode_with_name($id);
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}
	}


	//select2

	public function get_select2($func){
		$json = [];
		$data = $this->ordermdl->$func();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}


	public function update_barcode_qty_utility()
	{
		// $record =	$this->db_operations->get_recordlist('inward_stock_barcode');
		$record =	$this->ordermdl->get_update_barcode_qty_utility();
		// echo "<pre>";print_r($record);exit;
		foreach ($record as $key => $value) 
		{
			
			$db_total_ot_out_qty = $this->ordermdl->get_total_qty_out_trans($value['isb_id']);

			$this->db_operations->data_update('inward_stock_barcode',array('isb_sales_out_qty'=>$db_total_ot_out_qty[0]['total_ot_qty']),'isb_id',$value['ot_item_code']);
		}
	}




	// public function fabric_cutting_all_insert()
	// {	
	// 	$user_id = $this->session->userdata('user_id');
	// 	$fin_year = $this->session->userdata('fin_year');

	// 	$form_data = $this->input->post();

	// 	// echo "<pre>";print_r($form_data);exit;

	// 	foreach ($form_data['fab_cut_id'] as $key => $value) 
	// 	{
	// 		/*order transaction data*/
	// 		$order_trans = array();
			
	// 		if($value == 0) 
	// 		{
	// 			$order_trans['fab_cut_om_no'] 	= $form_data['fab_cut_om_no'][$key];
	// 			$order_trans['fab_cut_om_date'] 	= date('Y-m-d',strtotime($form_data['fab_cut_om_date'][$key]));
	// 			$order_trans['fab_cut_client_name'] 	= $form_data['fab_cut_client_name'][$key];
	// 			$order_trans['fab_cut_client_id'] 	= $form_data['fab_cut_client_id'][$key];
	// 			$order_trans['fab_cut_fabric_name'] 	= $form_data['fab_cut_fabric_name'][$key];
	// 			$order_trans['fab_cut_fabric_id'] 	= $form_data['fab_cut_fabric_id'][$key];
	// 			$order_trans['fab_cut_client_mobile1']= $form_data['fab_cut_client_mobile1'][$key];
	// 			$order_trans['fab_cut_isb_item_code'] = $form_data['fab_cut_isb_item_code'][$key];
	// 			$order_trans['fab_cut_isb_id'] 		= $form_data['fab_cut_isb_id'][$key];
	// 			$order_trans['fab_cut_out_qty'] 		= $form_data['fab_cut_out_qty'][$key];
	// 			$order_trans['fab_cut_user_id'] 		= $user_id;
	// 			$order_trans['fab_cut_fin_year'] 		= $fin_year;
	// 			$order_trans['fab_cut_date_create'] 	= date("Y-m-d H:i:s");

	// 			unset($form_data['hidden_fab_cut_out_qty'][$key]);

	// 			$result = $this->db_operations->data_insert('fabric_cutting_master', $order_trans);

	// 			$this->db_operations->data_update('order_trans',array('ot_fab_cut_id'=>$result),'ot_id',$form_data['ot_id'][$key]);


	// 			// $order_trans_result = $this->db_operations->data_insert('order_trans', $order_trans);
	// 		} 
			
	// 	}
	// }

	 public function add_attachment_image($cnt){
        $files = $_FILES;
        if(!empty($cnt)){
            $record = $this->add_attachment($files,'ot_attachment_'.$cnt);
        }else{
            $record = $this->add_attachment($files,'ot_attachment');
        }
        echo json_encode($record);
    }
    
    public function add_attachment($files,$attachment_name){
        $data=[];
        // echo "<pre>";print_r($files); 
        // echo "<pre>";print_r($attachment_name);exit;
        if(isset($files[$attachment_name]) && !empty($files[$attachment_name])){
            if($files[$attachment_name]['error'] == 0){
            	
                $_FILES[$attachment_name]['name']       = $files[$attachment_name]['name'];
                $_FILES[$attachment_name]['type']       = $files[$attachment_name]['type'];
                $_FILES[$attachment_name]['tmp_name']   = $files[$attachment_name]['tmp_name'];
                $_FILES[$attachment_name]['error']      = $files[$attachment_name]['error'];
                $_FILES[$attachment_name]['size']       = $files[$attachment_name]['size'];

                unset($config);
                $config                     = array();
                $config['upload_path']      = 'public/uploads/order_trans_attachment';
                $config['allowed_types']    =  'gif|jpg|png|jpeg';
                $config['max_size'] 		=  '1024';
                $file_name                  = $files[$attachment_name]['name'];
                if(!file_exists($config['upload_path'])){
                    mkdir($config['upload_path'], 0777);
                }
                $ext                        = strtolower(substr($file_name, strrpos($file_name, '.') + 1));
                $filename                   = 'order_trans_attachment_'.''.time().'.'.$ext;
                $config['file_name']        = $filename;

                $this->upload->initialize($config);
                if(!$this->upload->do_upload($attachment_name)){
                    return ['status' => FALSE, 'data' => [],  'msg' =>$this->upload->display_errors()];
                                   
                }
                $imageinfo = $this->upload->data();
                $full_path = $imageinfo['full_path'];
                    
                $data = $filename;
            }
        }
        return ['status' => TRUE, 'data' => $data,  'msg' =>''];
    }

    public function get_inv_details($om_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record['om_inv'] = $this->ordermdl->get_fin_year_wise_max_id_inv('order_master','om_invoice','om_fin_year',$_SESSION['fin_year']);
			$record['gst_type'] = $this->db_operations->get_record('order_master',array('om_id' => $om_id));  
			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}
	public function get_apparel_data_all()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_apparel_data_all();
			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function order_inv_trans_insert($om_id,$oit_id)
	{	
		$form_data = $this->input->post();

		/*order transaction data*/
		$order_trans = array();
		$order = array();

		$order['om_invoice'] 		= $form_data['om_invoice'];
		$order['om_invoice_date'] = date('Y-m-d', strtotime($form_data['om_invoice_date']));

		$order['om_cgst_amt'] 		= $form_data['oit_cgst_amt'];
		$order['om_sgst_amt'] 		= $form_data['oit_sgst_amt'];
		$order['om_igst_amt'] 		= $form_data['oit_igst_amt'];
		$order['om_taxable_total'] 	= $form_data['oit_taxable'];

		
		if($oit_id == 0) 
		{
			$order_trans['oit_om_id'] 		= $om_id;
			$order_trans['oit_type'] 		= $form_data['oit_type'];
			$order_trans['oit_item_id'] 	= isset($form_data['oit_item_id']) ? $form_data['oit_item_id'] : '';
			$order_trans['oit_rate'] 		= $form_data['oit_rate'];
			$order_trans['oit_amt'] 		= $form_data['oit_final_total'];
			$order_trans['oit_qty'] 		= $form_data['oit_qty'];
			$oit_id = $this->db_operations->data_insert('order_inv_trans', $order_trans);
			if($oit_id < 1){
				echo json_encode( ['status' => FALSE, 'data' => FALSE, 'msg' => 'Order Transaction not inserted in Stitching.']);
			}
		} 
		else 
		{
			$order_trans['oit_om_id'] 		= $om_id;
			$order_trans['oit_type'] 		= $form_data['oit_type'];
			$order_trans['oit_item_id'] 	= isset($form_data['oit_item_id']) ? $form_data['ot_item_id'] : '';
			$order_trans['oit_rate'] 		= $form_data['oit_rate'];
			$order_trans['oit_amt'] 		= $form_data['oit_final_total'];
			$order_trans['oit_qty'] 		= $form_data['oit_qty'];
			
			if($this->db_operations->data_update('order_inv_trans',$order_trans,'oit_id',$form_data['oit_id']) < 1){
				echo json_encode( ['status' => FALSE, 'data' => FALSE, 'msg' => 'Order Transaction Not updated in Stitching.']);
			}
		}

		if($this->db_operations->data_update('order_master',$order,'om_id',$om_id) < 1){
				echo json_encode(['status' => FALSE, 'data' => FALSE, 'msg' => 'Order master Not updated.']);
			}
		
		// return ['status' => TRUE, 'data' => TRUE, 'msg' => ''];
		echo json_encode(['status' => TRUE, 'data' => TRUE, 'msg' => 'Invoice Generated Successfully.']);
	}

	public function invoice_delete($om_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			/*db transaction starts*/
			$this->db->trans_begin();
			/*delete order records*/
			
				$this->db_operations->data_update('order_master' , ['om_invoice' => '','om_invoice_date' => '','om_taxable_total' => 0,'om_cgst_amt' => 0,'om_sgst_amt' => 0,'om_igst_amt' => 0], 'om_id', $om_id);
				$this->db_operations->delete_record('order_inv_trans', array('oit_om_id' => $om_id));
				
				if ($this->db->trans_status() === FALSE) {
				    $this->db->trans_rollback();
				    echo 0;
				} else {
				    $this->db->trans_commit();
					echo 1;
				}	
			
		}
		else 
		{
			redirect('loginctrl/logout');
		}
	}


	public function utility_update_new()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record 	= $this->ordermdl->get_utility_data_new();	
			// echo "<pre>";print_r($record);exit();
			if(!empty($record)) 
			{
				foreach ($record as $key => $value) 
				{
					$client_measurement = $this->ordermdl->get_client_measurement($value['om_client_id'],$value['ot_item_id']);
					// echo "<pre>";print_r($client_measurement);exit();
					if(!empty($client_measurement)) 
					{
						$otm_measurement = [];

						$otm_measurement['otm_om_id'] 		= $value['ot_om_id'];
						$otm_measurement['otm_ot_id'] 		= $value['ot_id'];
						$otm_measurement['otm_client_id'] 	= $value['om_client_id'];
						$otm_measurement['otm_app_id'] 		= $value['ot_item_id'];

						$otm_measurement['otm_mm_id'] 		= $client_measurement[0]['ct_mm_id'];
						$otm_measurement['otm_notes'] 		= $client_measurement[0]['ct_notes'];
						$otm_measurement['otm_notes_maap'] 	= $client_measurement[0]['ct_notes_maap'];
						$otm_measurement['otm_lenght'] 		= $client_measurement[0]['ct_lenght'];
						$otm_measurement['otm_shoulder'] 	= $client_measurement[0]['ct_shoulder'];
						$otm_measurement['otm_full_sleeves'] = $client_measurement[0]['ct_full_sleeves'];
						$otm_measurement['otm_half_sleeves'] = $client_measurement[0]['ct_half_sleeves'];
						$otm_measurement['otm_chest'] 		= $client_measurement[0]['ct_chest'];

						$otm_measurement['otm_below_chest'] = $client_measurement[0]['ct_below_chest'];
						$otm_measurement['otm_stomach'] 	= $client_measurement[0]['ct_stomach'];

						$otm_measurement['otm_hip'] 		= $client_measurement[0]['ct_hip'];
						$otm_measurement['otm_neck'] 	= $client_measurement[0]['ct_neck'];
						$otm_measurement['otm_cuff'] 	= $client_measurement[0]['ct_cuff'];
						$otm_measurement['otm_bottom'] 		= $client_measurement[0]['ct_bottom'];
						$otm_measurement['otm_koni'] 		= $client_measurement[0]['ct_koni'];
						$otm_measurement['otm_f1'] 			= $client_measurement[0]['ct_f1'];
						$otm_measurement['otm_f2'] 			= $client_measurement[0]['ct_f2'];
						$otm_measurement['otm_f3'] 			= $client_measurement[0]['ct_f3'];
						$otm_measurement['otm_f4'] 			= $client_measurement[0]['ct_f4'];
						$otm_measurement['otm_b1'] 			= $client_measurement[0]['ct_b1'];
						$otm_measurement['otm_b2'] 			= $client_measurement[0]['ct_b2'];
						$otm_measurement['otm_b3'] 			= $client_measurement[0]['ct_b3'];
						$otm_measurement['otm_b4'] 			= $client_measurement[0]['ct_b4'];

						$otm_measurement['otm_a_shirt'] 	= $client_measurement[0]['ct_a_shirt'];
						$otm_measurement['otm_fashion_double'] = $client_measurement[0]['ct_fashion_double'];
						$otm_measurement['otm_1_pocket'] 	= $client_measurement[0]['ct_1_pocket'];
						$otm_measurement['otm_paachal_daat']= $client_measurement[0]['ct_paachal_daat'];
						$otm_measurement['otm_up_stich'] 	= $client_measurement[0]['ct_up_stich'];

						$otm_measurement['otm_inseam'] 		= $client_measurement[0]['ct_inseam'];
						$otm_measurement['otm_waist'] 		= $client_measurement[0]['ct_waist'];
						$otm_measurement['otm_fly'] 		= $client_measurement[0]['ct_fly'];
						$otm_measurement['otm_knee'] 		= $client_measurement[0]['ct_knee'];
						$otm_measurement['otm_f_b'] 		= $client_measurement[0]['ct_f_b'];

						$otm_measurement['otm_thigh'] 		= $client_measurement[0]['ct_thigh'];
						$otm_measurement['otm_aagal_thi_low'] = $client_measurement[0]['ct_aagal_thi_low'];
						$otm_measurement['otm_padbon'] 		= $client_measurement[0]['ct_padbon'];
						$otm_measurement['otm_1_50_bw'] 	= $client_measurement[0]['ct_1_50_bw'];
						$otm_measurement['otm_1_3_4_loops'] = $client_measurement[0]['ct_1_3_4_loops'];
						$otm_measurement['otm_cross_pocket'] = $client_measurement[0]['ct_cross_pocket'];
						$otm_measurement['otm_2_hips'] 		= $client_measurement[0]['ct_2_hips'];
						$otm_measurement['otm_1_watch'] 	= $client_measurement[0]['ct_1_watch'];
						$otm_measurement['otm_1_plate'] 	= $client_measurement[0]['ct_1_plate'];

						$otm_measurement['otm_1_50_lb'] 	= $client_measurement[0]['ct_1_50_lb'];
						$otm_measurement['otm_mundo'] 		= $client_measurement[0]['ct_mundo'];
						$otm_measurement['otm_loosing'] 	= $client_measurement[0]['ct_loosing'];
						$otm_measurement['otm_alag_collar'] = $client_measurement[0]['ct_alag_collar'];
						$otm_measurement['otm_cutway'] 		= $client_measurement[0]['ct_cutway'];
						$otm_measurement['otm_astro'] 		= $client_measurement[0]['ct_astro'];
						$otm_measurement['otm_charlie'] 	= $client_measurement[0]['ct_charlie'];
						$otm_measurement['otm_chinese'] 	= $client_measurement[0]['ct_chinese'];

						$otm_measurement['otm_alag_collar_value'] 	= $client_measurement[0]['ct_alag_collar_value'];
						$otm_measurement['otm_cutway_value'] = $client_measurement[0]['ct_cutway_value'];
						$otm_measurement['otm_astro_value']  = $client_measurement[0]['ct_astro_value'];
						$otm_measurement['otm_charlie_value'] = $client_measurement[0]['ct_charlie_value'];
						$otm_measurement['otm_chinese_value'] = $client_measurement[0]['ct_chinese_value'];
						$otm_measurement['otm_1_50_loops'] 	  = $client_measurement[0]['ct_1_50_loops'];

						$otm_measurement['otm_1_hip'] 		= $client_measurement[0]['ct_1_hip'];
						$otm_measurement['otm_no_pocket'] 	= $client_measurement[0]['ct_no_pocket'];
						$otm_measurement['otm_1_50__bw'] 	= $client_measurement[0]['ct_1_50__bw'];
						$otm_measurement['otm_1_50_a_belt'] = $client_measurement[0]['ct_1_50_a_belt'];
						$otm_measurement['otm_2_watch'] 	= $client_measurement[0]['ct_2_watch'];
						$otm_measurement['otm_half_back'] 	= $client_measurement[0]['ct_half_back'];

						$otm_measurement['otm_half_shoulder'] 	= $client_measurement[0]['ct_half_shoulder'];
						$otm_measurement['otm_sleeves'] 	= $client_measurement[0]['ct_sleeves'];
						$otm_measurement['otm_front_chest'] = $client_measurement[0]['ct_front_chest'];
						$otm_measurement['otm_cross_back'] 	= $client_measurement[0]['ct_cross_back'];
						$otm_measurement['otm_2_button_v_shape'] 	= $client_measurement[0]['ct_2_button_v_shape'];
						$otm_measurement['otm_side_cut'] 	= $client_measurement[0]['ct_side_cut'];

						$otm_measurement['otm_chinese_peak_collar'] 	= $client_measurement[0]['ct_chinese_peak_collar'];
						$otm_measurement['otm_shoulder_jali'] 	= $client_measurement[0]['ct_shoulder_jali'];
						$otm_measurement['otm_lastic___nadi'] 	= $client_measurement[0]['ct_lastic___nadi'];
						$otm_measurement['otm_down_round_shape'] 	= $client_measurement[0]['ct_down_round_shape'];
						$otm_measurement['otm_jacket_lenght'] 	= $client_measurement[0]['ct_jacket_lenght'];
						$otm_measurement['otm_2_button_d_b_collar'] 	= $client_measurement[0]['ct_2_button_d_b_collar'];

						$otm_measurement['otm_band_patti'] 	= $client_measurement[0]['ct_band_patti'];
						$otm_measurement['otm_down_round'] 	= $client_measurement[0]['ct_down_round'];
						$otm_measurement['otm_1_button_tuxedo'] 	= $client_measurement[0]['ct_1_button_tuxedo'];
						$otm_measurement['otm_box_patti'] 	= $client_measurement[0]['ct_box_patti'];
						$otm_measurement['otm_full_open'] 	= $client_measurement[0]['ct_full_open'];
						$otm_measurement['otm_insight_patti'] 	= $client_measurement[0]['ct_insight_patti'];

						$otm_measurement['otm_b_shirt'] 	= $client_measurement[0]['ct_b_shirt'];
						$otm_measurement['otm_back_lastic'] 	= $client_measurement[0]['ct_back_lastic'];
						$otm_measurement['otm_2_plate'] 	= $client_measurement[0]['ct_2_plate'];
						$otm_measurement['otm_side_pocket'] 	= $client_measurement[0]['ct_side_pocket'];
						$otm_measurement['otm_side_pakki'] 	= $client_measurement[0]['ct_side_pakki'];
						$otm_measurement['otm_1_button_v_shape'] 	= $client_measurement[0]['ct_1_button_v_shape'];

						$otm_measurement['otm_concil_button'] 	= $client_measurement[0]['ct_concil_button'];
						$otm_measurement['otm_shirt_collar'] 	= $client_measurement[0]['ct_shirt_collar'];
						$otm_measurement['otm_lastic__nadi'] 	= $client_measurement[0]['ct_lastic__nadi'];
						$otm_measurement['otm_2_button_double_breast'] 	= $client_measurement[0]['ct_2_button_double_breast'];
						$otm_measurement['otm_nadi'] 	= $client_measurement[0]['ct_nadi'];
						$otm_measurement['otm_overlook'] 	= $client_measurement[0]['ct_overlook'];

						$otm_measurement['otm_rajwadi'] 	= $client_measurement[0]['ct_rajwadi'];
						$otm_measurement['otm_box_plate'] 	= $client_measurement[0]['ct_box_plate'];
						$otm_measurement['otm_bottom_fold'] 	= $client_measurement[0]['ct_bottom_fold'];
						$otm_measurement['otm_back_lenght'] 	= $client_measurement[0]['ct_back_lenght'];
						$otm_measurement['otm_2_pocket'] 	= $client_measurement[0]['ct_2_pocket'];
						$otm_measurement['otm_centre_cut'] 	= $client_measurement[0]['ct_centre_cut'];
						$otm_measurement['otm_2_lb_gaaj_button'] 	= $client_measurement[0]['ct_2_lb_gaaj_button'];

						$id  = $this->db_operations->data_insert('order_trans_measurement', $otm_measurement);

						if($id < 1){
							echo "order trans measurement not inserted. order trans = ".$value['ot_id'];
							return;
						}	

						if($this->db_operations->data_update('order_trans',array('ot_otm_id' =>$id), 'ot_id', $value['ot_id']) < 1){
							echo "order trans not updated. order trans = ".$value['ot_id']." and otm id =".$id;
							return;
						}

					}

					// echo "<pre>";print_r($client_measurement);exit();
				}
			}
			echo "Successfully inserted !!!";
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function utility_update_new_b2()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record 	= $this->ordermdl->get_utility_data_new_b2();	
			// echo "<pre>";print_r($record);exit();
			$cnt = 0;
			$cnt1 = 0;
			if(!empty($record)) 
			{
				foreach ($record as $key => $value) 
				{
					$client_measurement = $this->ordermdl->get_client_measurement($value['otm_client_id'],$value['otm_app_id']);
					$cnt++;
					// echo "<pre>";print_r($client_measurement);exit();
					if(!empty($client_measurement)) 
					{
						$otm_measurement = [];

						// $otm_measurement['otm_b1'] 			= $client_measurement[0]['ct_b1'];
						$otm_measurement['otm_b2'] 			= $client_measurement[0]['ct_b2'];
						$otm_measurement['otm_b3'] 			= $client_measurement[0]['ct_b3'];
						$otm_measurement['otm_b4'] 			= $client_measurement[0]['ct_b4'];

						$cnt1++;
						if($this->db_operations->data_update('order_trans_measurement',$otm_measurement, 'otm_id', $value['otm_id']) < 1){
							echo "order trans not updated. order trans = ".$value['otm_id']." and otm id =".$value['otm_id'];
							return;
						}

					}

					// echo "<pre>";print_r($client_measurement);exit();
				}
			}
			echo "Successfully inserted $cnt - $cnt1 !!!";
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}


/**/
}
?>
